<div id="setup-form" class="h-full flex flex-col">
    <div class="mb-8">
        <span class="inline-block px-3 py-1 bg-primary-100 text-primary-700 text-[10px] font-bold uppercase tracking-wider rounded-lg mb-4">Final Step</span>
        <h2 class="text-3xl font-bold text-navy-900 mb-4 tracking-tight">Admin Account</h2>
        <p class="text-slate-500 text-sm leading-relaxed">
            Create your primary administrative account. You will use these credentials to log in to the admin panel.
        </p>
    </div>

    <form id="installForm" class="space-y-4 flex-1">
        <div class="space-y-4">
            <div class="space-y-1.5">
                <label class="text-[10px] font-bold uppercase tracking-widest text-slate-400 ml-1">Full Name</label>
                <input type="text" name="name" required
                    class="w-full bg-slate-50 border border-slate-200 rounded-xl py-3 px-4 text-sm focus:bg-white focus:border-primary-500 transition-all outline-none" placeholder="Administrative User">
            </div>
            <div class="space-y-1.5">
                <label class="text-[10px] font-bold uppercase tracking-widest text-slate-400 ml-1">Email Address</label>
                <input type="email" name="email" required
                    class="w-full bg-slate-50 border border-slate-200 rounded-xl py-3 px-4 text-sm focus:bg-white focus:border-primary-500 transition-all outline-none" placeholder="admin@example.com">
            </div>
            <div class="space-y-1.5">
                <label class="text-[10px] font-bold uppercase tracking-widest text-slate-400 ml-1">Password</label>
                <input type="password" name="password" required
                    class="w-full bg-slate-50 border border-slate-200 rounded-xl py-3 px-4 text-sm focus:bg-white focus:border-primary-500 transition-all outline-none" placeholder="••••••••">
            </div>
        </div>

        <div class="pt-8 flex justify-between items-center mt-auto">
            <a href="?step=3" class="text-sm font-bold text-slate-400 hover:text-navy-900 transition-colors">Back</a>
            
            <button type="submit" id="submitBtn" class="group bg-navy-900 hover:bg-navy-800 text-white font-bold py-4 px-12 rounded-2xl transition-all shadow-xl shadow-navy-900/10 flex items-center gap-2">
                Install Now
                <svg width="16" height="16" class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
            </button>
        </div>
    </form>
</div>

<!-- Progress Overlay -->
<div id="progress-overlay" class="hidden h-full flex flex-col items-center justify-center text-center py-10">
    <div class="relative w-32 h-32 mb-10">
        <div class="absolute inset-0 rounded-full border-4 border-slate-100"></div>
        <div id="progress-spinner" class="absolute inset-0 rounded-full border-4 border-primary-600 border-t-transparent animate-spin"></div>
        <div class="absolute inset-0 flex items-center justify-center">
            <span id="progress-percent" class="text-2xl font-bold text-navy-900">0%</span>
        </div>
    </div>
    
    <h3 id="progress-title" class="text-2xl font-bold text-navy-900 mb-2">Installing...</h3>
    <p id="progress-subtitle" class="text-slate-500 text-sm max-w-xs mx-auto">Please wait while we set up your application. Do not close this window.</p>
    
    <div class="w-full max-w-sm mt-10">
        <div class="relative h-1.5 w-full bg-slate-100 rounded-full overflow-hidden">
            <div id="progress-bar" class="absolute top-0 left-0 h-full bg-primary-600 transition-all duration-500" style="width: 0%"></div>
        </div>
        <div id="log-container" class="mt-4 text-[10px] text-slate-400 font-mono text-left max-h-24 overflow-y-auto space-y-1">
            <!-- Logs will appear here -->
        </div>
    </div>
</div>

<script>
document.getElementById('installForm').addEventListener('submit', async (e) => {
    e.preventDefault();
    
    const formData = new FormData(e.target);
    const data = Object.fromEntries(formData.entries());
    
    // Switch UI
    document.getElementById('setup-form').classList.add('hidden');
    const overlay = document.getElementById('progress-overlay');
    overlay.classList.remove('hidden');
    overlay.classList.add('flex');
    
    const steps = [
        { name: 'Generating Environment File', percent: 20, action: 'gen_env' },
        { name: 'Running Database Migrations', percent: 50, action: 'migrate' },
        { name: 'Seeding Initial Data', percent: 75, action: 'seed' },
        { name: 'Creating Admin Account', percent: 90, action: 'create_admin' },
        { name: 'Optimizing Application', percent: 100, action: 'optimize' }
    ];
    
    const log = (msg, type = 'info') => {
        const container = document.getElementById('log-container');
        const entry = document.createElement('div');
        entry.className = type === 'error' ? 'text-red-500' : '';
        entry.textContent = `> ${msg}`;
        container.appendChild(entry);
        container.scrollTop = container.scrollHeight;
    };

    for (const step of steps) {
        document.getElementById('progress-title').textContent = step.name;
        document.getElementById('progress-bar').style.width = `${step.percent}%`;
        document.getElementById('progress-percent').textContent = `${step.percent}%`;
        log(`Executing: ${step.name}...`);
        
        try {
            const response = await fetch('/install/process.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ action: step.action, ...data })
            });
            const result = await response.json();
            
            if (!result.success) {
                throw new Error(result.message || 'Unknown error occurred');
            }
            log(`Success: ${step.name}`);
        } catch (error) {
            log(error.message, 'error');
            document.getElementById('progress-title').textContent = 'Installation Failed';
            document.getElementById('progress-spinner').classList.remove('animate-spin');
            document.getElementById('progress-spinner').classList.add('border-red-500');
            document.getElementById('progress-percent').innerHTML = '<svg width="32" height="32" class="w-8 h-8 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>';
            return;
        }
    }
    
    // Finished
    setTimeout(() => {
        window.location.href = '?step=5';
    }, 1000);
});
</script>
