<?php
$db_error = null;
$db_success = false;

// Initialize session data if not set
if (!isset($_SESSION['db_config'])) {
    $_SESSION['db_config'] = [
        'host' => '127.0.0.1',
        'database' => '',
        'username' => '',
        'password' => ''
    ];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $host = $_POST['host'] ?? '';
    $database = $_POST['database'] ?? '';
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // Update session
    $_SESSION['db_config'] = [
        'host' => $host,
        'database' => $database,
        'username' => $username,
        'password' => $password
    ];

    try {
        $dsn = "mysql:host=$host;dbname=$database;charset=utf8mb4";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_TIMEOUT => 5,
        ];
        $pdo = new PDO($dsn, $username, $password, $options);
        $db_success = true;
    }
    catch (PDOException $e) {
        $db_error = $e->getMessage();
    }
}
?>

<div class="h-full flex flex-col">
    <div class="mb-8">
        <span class="inline-block px-3 py-1 bg-primary-100 text-primary-700 text-[10px] font-bold uppercase tracking-wider rounded-lg mb-4">Configuration</span>
        <h2 class="text-3xl font-bold text-navy-900 mb-4 tracking-tight">Database Settings</h2>
        <p class="text-slate-500 text-sm leading-relaxed">
            Enter your MySQL database credentials. These will be used to create the tables and save your application data.
        </p>
    </div>

    <?php if ($db_error): ?>
    <div class="mb-6 p-4 bg-red-50 border border-red-100 rounded-2xl flex gap-3 items-start animate-shake">
        <div class="w-8 h-8 bg-red-500 rounded-lg flex items-center justify-center text-white shrink-0 shadow-sm">
            <svg width="16" height="16" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/></svg>
        </div>
        <div>
            <h4 class="text-xs font-bold text-red-700 mb-1">Connection Failed</h4>
            <p class="text-[10px] text-red-600 leading-normal"><?php echo htmlspecialchars($db_error); ?></p>
        </div>
    </div>
    <?php
elseif ($db_success): ?>
    <div class="mb-6 p-4 bg-emerald-50 border border-emerald-100 rounded-2xl flex gap-3 items-start animate-bounce-subtle">
        <div class="w-8 h-8 bg-emerald-500 rounded-lg flex items-center justify-center text-white shrink-0 shadow-sm">
            <svg width="16" height="16" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"/></svg>
        </div>
        <div>
            <h4 class="text-xs font-bold text-emerald-700 mb-1">Connected Successfully!</h4>
            <p class="text-[10px] text-emerald-600 leading-normal">Database connection established. You can now proceed to the next step.</p>
        </div>
    </div>
    <?php
endif; ?>

    <form method="POST" action="?step=3" class="space-y-4 flex-1">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="space-y-1.5">
                <label class="text-[10px] font-bold uppercase tracking-widest text-slate-400 ml-1">Database Host</label>
                <input type="text" name="host" value="<?php echo htmlspecialchars($_SESSION['db_config']['host']); ?>" required
                    class="w-full bg-slate-50 border border-slate-200 rounded-xl py-3 px-4 text-sm focus:bg-white focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition-all outline-none" placeholder="127.0.0.1">
            </div>
            <div class="space-y-1.5">
                <label class="text-[10px] font-bold uppercase tracking-widest text-slate-400 ml-1">Database Name</label>
                <input type="text" name="database" value="<?php echo htmlspecialchars($_SESSION['db_config']['database']); ?>" required
                    class="w-full bg-slate-50 border border-slate-200 rounded-xl py-3 px-4 text-sm focus:bg-white focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition-all outline-none" placeholder="e_commerce_db">
            </div>
            <div class="space-y-1.5">
                <label class="text-[10px] font-bold uppercase tracking-widest text-slate-400 ml-1">Username</label>
                <input type="text" name="username" value="<?php echo htmlspecialchars($_SESSION['db_config']['username']); ?>" required
                    class="w-full bg-slate-50 border border-slate-200 rounded-xl py-3 px-4 text-sm focus:bg-white focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition-all outline-none" placeholder="db_user">
            </div>
            <div class="space-y-1.5">
                <label class="text-[10px] font-bold uppercase tracking-widest text-slate-400 ml-1">Password</label>
                <input type="password" name="password" value="<?php echo htmlspecialchars($_SESSION['db_config']['password']); ?>"
                    class="w-full bg-slate-50 border border-slate-200 rounded-xl py-3 px-4 text-sm focus:bg-white focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition-all outline-none" placeholder="••••••••">
            </div>
        </div>

        <div class="pt-6 flex justify-between items-center">
            <a href="?step=2" class="text-sm font-bold text-slate-400 hover:text-navy-900 transition-colors">Back</a>
            
            <div class="flex gap-3">
                <button type="submit" class="bg-white border-2 border-slate-200 text-slate-600 font-bold py-4 px-8 rounded-2xl transition-all hover:bg-slate-50 active:scale-95 text-sm">
                    Test Connection
                </button>
                
                <?php if ($db_success): ?>
                <a href="?step=4" class="group bg-navy-900 hover:bg-navy-800 text-white font-bold py-4 px-10 rounded-2xl transition-all shadow-xl shadow-navy-900/10 flex items-center gap-2">
                    Next Step
                    <svg width="16" height="16" class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
                </a>
                <?php
endif; ?>
            </div>
        </div>
    </form>
</div>

<style>
@keyframes shake {
  0%, 100% { transform: translateX(0); }
  10%, 30%, 50%, 70%, 90% { transform: translateX(-2px); }
  20%, 40%, 60%, 80% { transform: translateX(2px); }
}
.animate-shake { animation: shake 0.5s cubic-bezier(.36,.07,.19,.97) both; }

@keyframes bounce-subtle {
  0%, 100% { transform: translateY(0); }
  50% { transform: translateY(-3px); }
}
.animate-bounce-subtle { animation: bounce-subtle 2s infinite ease-in-out; }
</style>
