<div class="h-full flex flex-col items-center justify-center text-center">
    <div class="w-20 h-20 bg-emerald-500 rounded-3xl shadow-xl shadow-emerald-500/20 flex items-center justify-center text-white mb-8 animate-bounce-subtle">
        <svg width="40" height="40" class="w-10 h-10" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"/></svg>
    </div>

    <h2 class="text-3xl font-bold text-navy-900 mb-4 tracking-tight">Installation Successful!</h2>
    <p class="text-slate-500 text-sm leading-relaxed max-w-sm mx-auto mb-10">
        Your application has been successfully configured and is ready to use. 
        The administrator account has been created and the environment is optimized.
    </p>

    <div class="w-full space-y-4 mb-10 text-left">
        <div class="p-4 bg-amber-50 border border-amber-100 rounded-2xl flex gap-3 items-start">
            <div class="w-8 h-8 bg-amber-500 rounded-lg flex items-center justify-center text-white shrink-0 shadow-sm">
                <svg width="16" height="16" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/></svg>
            </div>
            <div>
                <h4 class="text-xs font-bold text-amber-900 mb-1">Important Security Step</h4>
                <p class="text-[10px] text-amber-800 leading-normal">
                    For security reasons, you must now <strong>delete</strong> the <code>install/</code> folder 
                    and the <code>public/install.php</code> file from your server.
                </p>
            </div>
        </div>

        <div class="p-4 bg-blue-50 border border-blue-100 rounded-2xl flex gap-3 items-start">
            <div class="w-8 h-8 bg-blue-500 rounded-lg flex items-center justify-center text-white shrink-0 shadow-sm">
                <svg width="16" height="16" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
            <div>
                <h4 class="text-xs font-bold text-blue-900 mb-1">Storage Access</h4>
                <p class="text-[10px] text-blue-800 leading-normal">
                    If images are not showing, check if your server supports symlinks. Alternatively, use the 
                    cPanel "File Manager" to create a link from <code>public/storage</code> to <code>storage/app/public</code>.
                </p>
            </div>
        </div>
    </div>

    <div class="flex flex-col sm:flex-row gap-4 w-full">
        <a href="/" class="flex-1 bg-slate-100 hover:bg-slate-200 text-slate-700 font-bold py-4 px-6 rounded-2xl transition-all text-sm">
            Visit Website
        </a>
        <a href="/admin/login" class="flex-1 bg-navy-900 hover:bg-navy-800 text-white font-bold py-4 px-6 rounded-2xl transition-all shadow-xl shadow-navy-900/10 text-sm">
            Go to Admin Panel
        </a>
    </div>
</div>

<style>
@keyframes bounce-subtle {
  0%, 100% { transform: translateY(0); }
  50% { transform: translateY(-5px); }
}
.animate-bounce-subtle { animation: bounce-subtle 3s infinite ease-in-out; }
</style>
