<?php
error_reporting(E_ALL);
ini_set('display_errors', 0); // Disable display errors for JSON response
session_start();

define('ROOT_PATH', dirname(__DIR__));

header('Content-Type: application/json');

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || !isset($data['action'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

$action = $data['action'];
$db_config = $_SESSION['db_config'] ?? null;

if (!$db_config && $action !== 'test') {
    echo json_encode(['success' => false, 'message' => 'Database configuration missing']);
    exit;
}

try {
    switch ($action) {
        case 'gen_env':
            $app_url = 'http://' . $_SERVER['HTTP_HOST'];
            $app_key = 'base64:' . base64_encode(random_bytes(32));

            $env_content = "APP_NAME=Laravel\n";
            $env_content .= "APP_ENV=production\n";
            $env_content .= "APP_KEY=$app_key\n";
            $env_content .= "APP_DEBUG=false\n";
            $env_content .= "APP_URL=$app_url\n\n";

            $env_content .= "LOG_CHANNEL=stack\n\n";

            $env_content .= "DB_CONNECTION=mysql\n";
            $env_content .= "DB_HOST=" . $db_config['host'] . "\n";
            $env_content .= "DB_PORT=3306\n";
            $env_content .= "DB_DATABASE=" . $db_config['database'] . "\n";
            $env_content .= "DB_USERNAME=" . $db_config['username'] . "\n";
            $env_content .= "DB_PASSWORD=" . $db_config['password'] . "\n\n";

            $env_content .= "BROADCAST_DRIVER=log\n";
            $env_content .= "CACHE_DRIVER=file\n";
            $env_content .= "FILESYSTEM_DRIVER=local\n";
            $env_content .= "QUEUE_CONNECTION=sync\n";
            $env_content .= "SESSION_DRIVER=file\n";
            $env_content .= "SESSION_LIFETIME=120\n";

            file_put_contents(ROOT_PATH . '/.env', $env_content);
            echo json_encode(['success' => true, 'message' => 'Environment file created']);
            break;

        case 'migrate':
            bootstrap_laravel();
            \Artisan::call('migrate', ['--force' => true]);
            echo json_encode(['success' => true, 'message' => 'Migrations completed']);
            break;

        case 'seed':
            bootstrap_laravel();
            \Artisan::call('db:seed', ['--force' => true]);
            echo json_encode(['success' => true, 'message' => 'Database seeding completed']);
            break;

        case 'create_admin':
            bootstrap_laravel();
            $admin_exists = \DB::table('users')->where('email', $data['email'])->exists();
            if (!$admin_exists) {
                \DB::table('users')->insert([
                    'name' => $data['name'],
                    'email' => $data['email'],
                    'password' => \Hash::make($data['password']),
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
            echo json_encode(['success' => true, 'message' => 'Admin account ready']);
            break;

        case 'optimize':
            bootstrap_laravel();
            \Artisan::call('optimize:clear');
            \Artisan::call('storage:link'); // Try symlink
            echo json_encode(['success' => true, 'message' => 'Optimization complete']);
            break;

        default:
            echo json_encode(['success' => false, 'message' => 'Unsupported action']);
    }
}
catch (\Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

function bootstrap_laravel()
{
    require ROOT_PATH . '/vendor/autoload.php';
    $app = require_once ROOT_PATH . '/bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
}
