<?php
$requirements = [
    'php' => [
        'name' => 'PHP Version (>= 7.3)',
        'check' => version_compare(PHP_VERSION, '7.3.0', '>='),
        'current' => PHP_VERSION,
        'type' => 'server'
    ],
    'pdo' => [
        'name' => 'PDO Extension',
        'check' => extension_loaded('pdo'),
        'type' => 'extension'
    ],
    'mbstring' => [
        'name' => 'Mbstring Extension',
        'check' => extension_loaded('mbstring'),
        'type' => 'extension'
    ],
    'openssl' => [
        'name' => 'OpenSSL Extension',
        'check' => extension_loaded('openssl'),
        'type' => 'extension'
    ],
    'tokenizer' => [
        'name' => 'Tokenizer Extension',
        'check' => extension_loaded('tokenizer'),
        'type' => 'extension'
    ],
    'xml' => [
        'name' => 'XML Extension',
        'check' => extension_loaded('xml'),
        'type' => 'extension'
    ],
    'curl' => [
        'name' => 'CURL Extension',
        'check' => extension_loaded('curl'),
        'type' => 'extension'
    ],
    'bcmath' => [
        'name' => 'BCMath Extension',
        'check' => extension_loaded('bcmath'),
        'type' => 'extension'
    ],
    'fileinfo' => [
        'name' => 'Fileinfo Extension',
        'check' => extension_loaded('fileinfo'),
        'type' => 'extension'
    ],
    'storage' => [
        'name' => 'storage/ directory writable',
        'check' => is_writable(ROOT_PATH . '/storage'),
        'type' => 'permission'
    ],
    'cache' => [
        'name' => 'bootstrap/cache/ directory writable',
        'check' => is_writable(ROOT_PATH . '/bootstrap/cache'),
        'type' => 'permission'
    ],
    'env' => [
        'name' => '.env file writable (or root directory)',
        'check' => is_writable(ROOT_PATH) || (file_exists(ROOT_PATH . '/.env') && is_writable(ROOT_PATH . '/.env')),
        'type' => 'permission'
    ]
];

$all_passed = true;
foreach ($requirements as $req) {
    if (!$req['check']) {
        $all_passed = false;
        break;
    }
}
?>

<div class="h-full flex flex-col">
    <div class="mb-8">
        <span class="inline-block px-3 py-1 bg-primary-100 text-primary-700 text-[10px] font-bold uppercase tracking-wider rounded-lg mb-4">Verification</span>
        <h2 class="text-3xl font-bold text-navy-900 mb-4 tracking-tight">Requirement Check</h2>
        <p class="text-slate-500 text-sm leading-relaxed">
            We need to make sure your server environment is compatible with Laravel.
        </p>
    </div>

    <div class="space-y-3 flex-1 overflow-y-auto max-h-[380px] pr-2 custom-scrollbar">
        <?php foreach ($requirements as $key => $req): ?>
        <div class="p-4 rounded-xl border <?php echo $req['check'] ? 'bg-emerald-50/30 border-emerald-100' : 'bg-red-50/30 border-red-100'; ?> flex items-center justify-between transition-all">
            <div class="flex items-center gap-3">
                <div class="w-8 h-8 rounded-lg flex items-center justify-center <?php echo $req['check'] ? 'bg-emerald-500 text-white' : 'bg-red-500 text-white'; ?> shadow-sm">
                    <?php if ($req['check']): ?>
                        <svg width="16" height="16" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"/></svg>
                    <?php
    else: ?>
                        <svg width="16" height="16" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M6 18L18 6M6 6l12 12"/></svg>
                    <?php
    endif; ?>
                </div>
                <div>
                    <h5 class="text-xs font-bold text-navy-900"><?php echo $req['name']; ?></h5>
                    <?php if (isset($req['current'])): ?>
                        <p class="text-[10px] text-slate-500 font-medium">Current: <?php echo $req['current']; ?></p>
                    <?php
    endif; ?>
                </div>
            </div>
            <span class="text-[10px] font-bold uppercase tracking-wider <?php echo $req['check'] ? 'text-emerald-600' : 'text-red-600'; ?>">
                <?php echo $req['check'] ? 'Passed' : 'Failed'; ?>
            </span>
        </div>
        <?php
endforeach; ?>
    </div>

    <div class="mt-8 pt-8 border-t border-slate-100 flex justify-between items-center">
        <a href="?step=1" class="text-sm font-bold text-slate-400 hover:text-navy-900 transition-colors">Back</a>
        
        <?php if ($all_passed): ?>
        <a href="?step=3" class="group bg-navy-900 hover:bg-navy-800 text-white font-bold py-4 px-10 rounded-2xl transition-all shadow-xl shadow-navy-900/10 flex items-center gap-2">
            Continue
            <svg width="16" height="16" class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
        </a>
        <?php
else: ?>
        <button onclick="window.location.reload();" class="bg-red-500 hover:bg-red-600 text-white font-bold py-4 px-10 rounded-2xl transition-all shadow-xl shadow-red-500/10 active:scale-95">
            Retry Check
        </button>
        <?php
endif; ?>
    </div>
</div>

<style>
.custom-scrollbar::-webkit-scrollbar { width: 4px; }
.custom-scrollbar::-webkit-scrollbar-track { background: transparent; }
.custom-scrollbar::-webkit-scrollbar-thumb { background: #e2e8f0; border-radius: 10px; }
.custom-scrollbar::-webkit-scrollbar-thumb:hover { background: #cbd5e1; }
</style>
