<div class="h-full flex flex-col">
    <div class="mb-10">
        <span class="inline-block px-3 py-1 bg-primary-100 text-primary-700 text-[10px] font-bold uppercase tracking-wider rounded-lg mb-4">Welcome</span>
        <h2 class="text-3xl font-bold text-navy-900 mb-4 tracking-tight">Project Installation</h2>
        <p class="text-slate-500 leading-relaxed">
            Welcome to the automated installation wizard. This program will help you configure your 
            Laravel application and database on this server in just a few minutes.
        </p>
    </div>

    <div class="space-y-6">
        <div class="p-6 bg-slate-50 rounded-2xl border border-slate-100 flex items-start gap-4">
            <div class="w-10 h-10 bg-white rounded-xl shadow-sm border border-slate-100 flex items-center justify-center shrink-0">
                <svg width="20" height="20" class="w-5 h-5 text-primary-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
            <div>
                <h4 class="font-bold text-navy-900 text-sm mb-1">Before you start</h4>
                <p class="text-xs text-slate-500 leading-normal">
                    Please ensure you have created a MySQL database and have the credentials ready.
                    You will also need to know your site URL.
                </p>
            </div>
        </div>

        <div class="p-6 bg-slate-50 rounded-2xl border border-slate-100 flex items-start gap-4">
            <div class="w-10 h-10 bg-white rounded-xl shadow-sm border border-slate-100 flex items-center justify-center shrink-0">
                <svg width="20" height="20" class="w-5 h-5 text-primary-600" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/></svg>
            </div>
            <div>
                <h4 class="font-bold text-navy-900 text-sm mb-1">Security Note</h4>
                <p class="text-xs text-slate-500 leading-normal">
                    This installer will automatically delete itself once the installation is complete
                    to protect your server configuration.
                </p>
            </div>
        </div>
    </div>

    <div class="mt-auto pt-10 flex justify-end">
        <a href="?step=2" class="group bg-navy-900 hover:bg-navy-800 text-white font-bold py-4 px-10 rounded-2xl transition-all shadow-xl shadow-navy-900/10 flex items-center gap-2">
            Start Installation
            <svg width="16" height="16" class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/></svg>
        </a>
    </div>
</div>
