<?php
/**
 * Laravel Self-Contained cPanel Installer v2.0
 * 
 * SINGLE FILE — No external dependencies, no CDN, fully inline CSS.
 * Works on any cPanel shared hosting without terminal/SSH access.
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('max_execution_time', 300);

session_start();

// ── Path Detection (works regardless of extraction location) ──
$public_dir = __DIR__;
$root_dir = dirname($public_dir);

// Verify we're inside a Laravel project
if (!file_exists($root_dir . '/artisan') || !file_exists($root_dir . '/vendor/autoload.php')) {
    // Maybe the public folder IS the root (user extracted flat)
    // Try one more level up
    if (file_exists(dirname($root_dir) . '/artisan')) {
        $root_dir = dirname($root_dir);
    }
}

define('ROOT_PATH', $root_dir);
define('PUBLIC_PATH', $public_dir);

// ── Step Router ──
$step = $_GET['step'] ?? 'welcome';

// ── Handle AJAX actions from Step 4 ──
if ($step === 'process') {
    header('Content-Type: application/json');

    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    if (!$data || !isset($data['action'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid request']);
        exit;
    }

    $db_config = $_SESSION['db_config'] ?? null;

    try {
        switch ($data['action']) {
            case 'gen_env':
                $app_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'];
                $app_key = 'base64:' . base64_encode(random_bytes(32));

                $env = "APP_NAME=Laravel\n";
                $env .= "APP_ENV=production\n";
                $env .= "APP_KEY=$app_key\n";
                $env .= "APP_DEBUG=false\n";
                $env .= "APP_URL=$app_url\n\n";
                $env .= "LOG_CHANNEL=stack\n\n";
                $env .= "DB_CONNECTION=mysql\n";
                $env .= "DB_HOST=" . ($db_config['host'] ?? '127.0.0.1') . "\n";
                $env .= "DB_PORT=3306\n";
                $env .= "DB_DATABASE=" . ($db_config['database'] ?? '') . "\n";
                $env .= "DB_USERNAME=" . ($db_config['username'] ?? '') . "\n";
                $env .= "DB_PASSWORD=" . ($db_config['password'] ?? '') . "\n\n";
                $env .= "BROADCAST_DRIVER=log\n";
                $env .= "CACHE_DRIVER=file\n";
                $env .= "FILESYSTEM_DRIVER=local\n";
                $env .= "QUEUE_CONNECTION=sync\n";
                $env .= "SESSION_DRIVER=file\n";
                $env .= "SESSION_LIFETIME=120\n";

                file_put_contents(ROOT_PATH . '/.env', $env);
                echo json_encode(['success' => true, 'message' => '.env created']);
                break;

            case 'migrate':
                require ROOT_PATH . '/vendor/autoload.php';
                $app = require ROOT_PATH . '/bootstrap/app.php';
                $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
                $kernel->bootstrap();
                \Artisan::call('migrate', ['--force' => true]);
                echo json_encode(['success' => true, 'message' => \Artisan::output()]);
                break;

            case 'seed':
                require ROOT_PATH . '/vendor/autoload.php';
                $app = require ROOT_PATH . '/bootstrap/app.php';
                $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
                $kernel->bootstrap();
                \Artisan::call('db:seed', ['--force' => true]);
                echo json_encode(['success' => true, 'message' => \Artisan::output()]);
                break;

            case 'create_admin':
                require ROOT_PATH . '/vendor/autoload.php';
                $app = require ROOT_PATH . '/bootstrap/app.php';
                $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
                $kernel->bootstrap();

                $exists = \DB::table('users')->where('email', $data['email'])->exists();
                if (!$exists) {
                    \DB::table('users')->insert([
                        'name' => $data['name'],
                        'email' => $data['email'],
                        'password' => \Hash::make($data['password']),
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
                echo json_encode(['success' => true, 'message' => 'Admin created']);
                break;

            case 'optimize':
                require ROOT_PATH . '/vendor/autoload.php';
                $app = require ROOT_PATH . '/bootstrap/app.php';
                $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
                $kernel->bootstrap();
                \Artisan::call('optimize:clear');
                try {
                    \Artisan::call('storage:link');
                }
                catch (\Exception $e) { /* symlink may fail */
                }
                echo json_encode(['success' => true, 'message' => 'Optimized']);
                break;

            default:
                echo json_encode(['success' => false, 'message' => 'Unknown action']);
        }
    }
    catch (\Exception $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
    exit;
}

// ── Handle DB Test POST ──
$db_error = null;
$db_success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $step === 'database') {
    $_SESSION['db_config'] = [
        'host' => $_POST['host'] ?? '127.0.0.1',
        'database' => $_POST['database'] ?? '',
        'username' => $_POST['username'] ?? '',
        'password' => $_POST['password'] ?? ''
    ];

    try {
        $c = $_SESSION['db_config'];
        new PDO("mysql:host={$c['host']};dbname={$c['database']};charset=utf8mb4", $c['username'], $c['password'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_TIMEOUT => 5,
        ]);
        $db_success = true;
    }
    catch (PDOException $e) {
        $db_error = $e->getMessage();
    }
}

if (!isset($_SESSION['db_config'])) {
    $_SESSION['db_config'] = ['host' => '127.0.0.1', 'database' => '', 'username' => '', 'password' => ''];
}

// ── Environment Check Data ──
$checks = [
    ['PHP >= 7.3', version_compare(PHP_VERSION, '7.3.0', '>='), PHP_VERSION],
    ['PDO Extension', extension_loaded('pdo'), null],
    ['Mbstring Extension', extension_loaded('mbstring'), null],
    ['OpenSSL Extension', extension_loaded('openssl'), null],
    ['Tokenizer Extension', extension_loaded('tokenizer'), null],
    ['XML Extension', extension_loaded('xml'), null],
    ['cURL Extension', extension_loaded('curl'), null],
    ['BCMath Extension', extension_loaded('bcmath'), null],
    ['Fileinfo Extension', extension_loaded('fileinfo'), null],
    ['storage/ writable', is_writable(ROOT_PATH . '/storage'), null],
    ['bootstrap/cache/ writable', is_writable(ROOT_PATH . '/bootstrap/cache'), null],
    ['Root directory writable (.env)', is_writable(ROOT_PATH), null],
];
$all_checks_pass = !in_array(false, array_column($checks, 1));
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Installer</title>
<style>
/* ── Reset & Base ── */
*,*::before,*::after{box-sizing:border-box;margin:0;padding:0}
body{font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Helvetica,Arial,sans-serif;background:#f1f5f9;color:#1e293b;min-height:100vh;display:flex;align-items:center;justify-content:center;padding:20px}

/* ── Layout ── */
.shell{max-width:900px;width:100%;background:#fff;border-radius:20px;box-shadow:0 25px 50px -12px rgba(0,0,0,.1);display:flex;overflow:hidden;min-height:560px}
.sidebar{width:240px;background:#0f172a;color:#fff;padding:40px 28px;display:flex;flex-direction:column;flex-shrink:0}
.content{flex:1;padding:48px;display:flex;flex-direction:column}

/* ── Sidebar ── */
.logo{display:flex;align-items:center;gap:12px;margin-bottom:48px}
.logo-icon{width:36px;height:36px;background:#0284c7;border-radius:10px;display:flex;align-items:center;justify-content:center;font-weight:700;font-size:18px}
.logo h1{font-size:16px;font-weight:700;line-height:1.2}
.logo small{font-size:9px;text-transform:uppercase;letter-spacing:2px;color:#38bdf8;display:block}
.steps{list-style:none;flex:1}
.steps li{padding:10px 0 10px 16px;border-left:3px solid rgba(255,255,255,.1);margin-bottom:12px;font-size:13px;color:rgba(255,255,255,.35);transition:all .2s}
.steps li.active{border-left-color:#0284c7;color:#fff;font-weight:600}
.steps li.done{border-left-color:#22c55e;color:rgba(255,255,255,.6)}
.steps li span{display:block;font-size:9px;text-transform:uppercase;letter-spacing:1.5px;margin-bottom:2px;opacity:.6}
.foot{font-size:9px;opacity:.3;border-top:1px solid rgba(255,255,255,.08);padding-top:20px;margin-top:auto}

/* ── Content ── */
.badge{display:inline-block;background:#e0f2fe;color:#0284c7;font-size:9px;font-weight:700;text-transform:uppercase;letter-spacing:1.5px;padding:4px 10px;border-radius:6px;margin-bottom:16px}
h2{font-size:26px;font-weight:700;margin-bottom:8px}
.desc{color:#64748b;font-size:14px;line-height:1.6;margin-bottom:32px}

/* ── Cards ── */
.card{background:#f8fafc;border:1px solid #e2e8f0;border-radius:14px;padding:20px;display:flex;gap:14px;align-items:flex-start;margin-bottom:12px}
.card-icon{width:36px;height:36px;border-radius:10px;display:flex;align-items:center;justify-content:center;flex-shrink:0;font-size:18px}
.card h4{font-size:13px;font-weight:700;margin-bottom:2px}
.card p{font-size:11px;color:#64748b;line-height:1.5}

/* ── Buttons ── */
.btn{display:inline-flex;align-items:center;gap:8px;padding:14px 28px;border-radius:14px;font-weight:700;font-size:14px;text-decoration:none;border:none;cursor:pointer;transition:all .15s}
.btn-primary{background:#0f172a;color:#fff}
.btn-primary:hover{background:#1e293b}
.btn-outline{background:#fff;color:#475569;border:2px solid #e2e8f0}
.btn-outline:hover{background:#f8fafc}
.btn-danger{background:#ef4444;color:#fff}
.btn-back{background:none;color:#94a3b8;font-size:13px;font-weight:600;border:none;cursor:pointer;text-decoration:none;padding:0}
.btn-back:hover{color:#1e293b}
.actions{margin-top:auto;padding-top:32px;display:flex;justify-content:space-between;align-items:center}

/* ── Check list ── */
.check-list{list-style:none;max-height:340px;overflow-y:auto}
.check-item{display:flex;align-items:center;justify-content:space-between;padding:12px 16px;border-radius:10px;border:1px solid #e2e8f0;margin-bottom:6px}
.check-item.pass{background:#f0fdf4;border-color:#bbf7d0}
.check-item.fail{background:#fef2f2;border-color:#fecaca}
.check-left{display:flex;align-items:center;gap:10px}
.dot{width:24px;height:24px;border-radius:6px;display:flex;align-items:center;justify-content:center;font-size:12px;color:#fff;flex-shrink:0}
.dot.green{background:#22c55e}
.dot.red{background:#ef4444}
.check-name{font-size:12px;font-weight:600}
.check-ver{font-size:10px;color:#94a3b8;font-weight:500}
.check-status{font-size:9px;font-weight:700;text-transform:uppercase;letter-spacing:1px}
.check-status.pass{color:#16a34a}
.check-status.fail{color:#dc2626}

/* ── Forms ── */
.form-grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
.form-group{display:flex;flex-direction:column;gap:4px}
.form-group label{font-size:9px;font-weight:700;text-transform:uppercase;letter-spacing:1.5px;color:#94a3b8;padding-left:4px}
.form-group input{width:100%;background:#f8fafc;border:1px solid #e2e8f0;border-radius:10px;padding:12px 14px;font-size:13px;outline:none;transition:border .2s}
.form-group input:focus{border-color:#0284c7;background:#fff}

/* ── Alerts ── */
.alert{padding:14px 18px;border-radius:12px;display:flex;gap:12px;align-items:flex-start;margin-bottom:20px;font-size:12px}
.alert-error{background:#fef2f2;border:1px solid #fecaca;color:#991b1b}
.alert-success{background:#f0fdf4;border:1px solid #bbf7d0;color:#166534}
.alert-warn{background:#fffbeb;border:1px solid #fde68a;color:#92400e}
.alert-info{background:#eff6ff;border:1px solid #bfdbfe;color:#1e40af}
.alert-icon{width:28px;height:28px;border-radius:8px;display:flex;align-items:center;justify-content:center;flex-shrink:0;color:#fff;font-size:14px}

/* ── Progress ── */
.progress-wrap{display:none;flex-direction:column;align-items:center;justify-content:center;text-align:center;flex:1;padding:40px 0}
.spinner{width:80px;height:80px;border:4px solid #e2e8f0;border-top-color:#0284c7;border-radius:50%;animation:spin 1s linear infinite;margin-bottom:24px}
@keyframes spin{to{transform:rotate(360deg)}}
.prog-bar-wrap{width:100%;max-width:320px;height:6px;background:#e2e8f0;border-radius:3px;overflow:hidden;margin-top:24px}
.prog-bar{height:100%;background:#0284c7;border-radius:3px;transition:width .4s;width:0}
.log-box{margin-top:16px;font-family:monospace;font-size:10px;color:#94a3b8;text-align:left;max-height:80px;overflow-y:auto;width:100%;max-width:320px}
.log-box div.err{color:#ef4444}

/* ── Finish ── */
.finish-icon{width:72px;height:72px;background:#22c55e;border-radius:20px;display:flex;align-items:center;justify-content:center;color:#fff;font-size:36px;margin:0 auto 24px;box-shadow:0 10px 30px rgba(34,197,94,.25)}

/* ── Responsive ── */
@media(max-width:700px){.shell{flex-direction:column}.sidebar{width:100%;padding:24px;flex-direction:row;flex-wrap:wrap;gap:8px}.steps{display:flex;gap:8px;flex:unset}.steps li{border-left:none;border-bottom:3px solid rgba(255,255,255,.1);padding:4px 8px;margin:0;font-size:11px}.steps li span{display:none}.logo{margin-bottom:0}.foot{display:none}.content{padding:28px}}
</style>
</head>
<body>
<div class="shell">
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="logo">
            <div class="logo-icon">L</div>
            <div><h1>Installer</h1><small>v2.0 Standalone</small></div>
        </div>
        <ul class="steps">
            <li class="<?php echo $step === 'welcome' ? 'active' : ($step !== 'welcome' ? 'done' : ''); ?>"><span>Step 01</span>Welcome</li>
            <li class="<?php echo $step === 'environment' ? 'active' : (in_array($step, ['database', 'account', 'finish']) ? 'done' : ''); ?>"><span>Step 02</span>Environment</li>
            <li class="<?php echo $step === 'database' ? 'active' : (in_array($step, ['account', 'finish']) ? 'done' : ''); ?>"><span>Step 03</span>Database</li>
            <li class="<?php echo $step === 'account' ? 'active' : ($step === 'finish' ? 'done' : ''); ?>"><span>Step 04</span>Install</li>
            <li class="<?php echo $step === 'finish' ? 'active' : ''; ?>"><span>Step 05</span>Done!</li>
        </ul>
        <div class="foot">&copy; <?php echo date('Y'); ?> Deployment Engine</div>
    </div>

    <!-- Content -->
    <div class="content">

<?php if ($step === 'welcome'): ?>
        <!-- ════════ STEP 1: WELCOME ════════ -->
        <div class="badge">Welcome</div>
        <h2>Project Installation</h2>
        <p class="desc">This wizard will configure your Laravel application and database on this server. It takes about 2 minutes.</p>

        <div class="card">
            <div class="card-icon" style="background:#e0f2fe;color:#0284c7">ℹ</div>
            <div><h4>Before you start</h4><p>Create a MySQL database via cPanel and have the host, name, username, and password ready.</p></div>
        </div>
        <div class="card">
            <div class="card-icon" style="background:#fef3c7;color:#d97706">🔒</div>
            <div><h4>Security</h4><p>After installation, delete this <code>install.php</code> file and the <code>install/</code> folder from your server.</p></div>
        </div>

        <?php
    // Show path detection status
    $artisan_found = file_exists(ROOT_PATH . '/artisan');
    $vendor_found = file_exists(ROOT_PATH . '/vendor/autoload.php');
?>
        <div class="card" style="<?php echo($artisan_found && $vendor_found) ? 'border-color:#bbf7d0;background:#f0fdf4' : 'border-color:#fecaca;background:#fef2f2'; ?>">
            <div class="card-icon" style="<?php echo($artisan_found && $vendor_found) ? 'background:#dcfce7;color:#16a34a' : 'background:#fee2e2;color:#dc2626'; ?>"><?php echo($artisan_found && $vendor_found) ? '✓' : '✗'; ?></div>
            <div>
                <h4>Project Detection</h4>
                <p>Root: <code style="font-size:10px;background:#e2e8f0;padding:2px 6px;border-radius:4px"><?php echo ROOT_PATH; ?></code><br>
                artisan: <?php echo $artisan_found ? '✓' : '✗ NOT FOUND'; ?> &nbsp;|&nbsp; vendor: <?php echo $vendor_found ? '✓' : '✗ NOT FOUND'; ?></p>
            </div>
        </div>

        <div class="actions">
            <span></span>
            <?php if ($artisan_found && $vendor_found): ?>
            <a href="?step=environment" class="btn btn-primary">Start Installation →</a>
            <?php
    else: ?>
            <span style="color:#dc2626;font-size:12px;font-weight:600">⚠ Project files not detected. Re-check extraction.</span>
            <?php
    endif; ?>
        </div>

<?php
elseif ($step === 'environment'): ?>
        <!-- ════════ STEP 2: ENVIRONMENT ════════ -->
        <div class="badge">Verification</div>
        <h2>Environment Check</h2>
        <p class="desc">Verifying your server meets all requirements for Laravel.</p>

        <ul class="check-list">
        <?php foreach ($checks as $c): ?>
            <li class="check-item <?php echo $c[1] ? 'pass' : 'fail'; ?>">
                <div class="check-left">
                    <div class="dot <?php echo $c[1] ? 'green' : 'red'; ?>"><?php echo $c[1] ? '✓' : '✗'; ?></div>
                    <div>
                        <div class="check-name"><?php echo $c[0]; ?></div>
                        <?php if ($c[2]): ?><div class="check-ver">Current: <?php echo $c[2]; ?></div><?php
        endif; ?>
                    </div>
                </div>
                <div class="check-status <?php echo $c[1] ? 'pass' : 'fail'; ?>"><?php echo $c[1] ? 'Passed' : 'Failed'; ?></div>
            </li>
        <?php
    endforeach; ?>
        </ul>

        <div class="actions">
            <a href="?step=welcome" class="btn-back">← Back</a>
            <?php if ($all_checks_pass): ?>
            <a href="?step=database" class="btn btn-primary">Continue →</a>
            <?php
    else: ?>
            <a href="?step=environment" class="btn btn-danger">Retry Check</a>
            <?php
    endif; ?>
        </div>

<?php
elseif ($step === 'database'): ?>
        <!-- ════════ STEP 3: DATABASE ════════ -->
        <div class="badge">Configuration</div>
        <h2>Database Settings</h2>
        <p class="desc">Enter your MySQL credentials. Click "Test Connection" first.</p>

        <?php if ($db_error): ?>
        <div class="alert alert-error">
            <div class="alert-icon" style="background:#ef4444">✗</div>
            <div><strong>Connection Failed</strong><br><span style="font-size:11px"><?php echo htmlspecialchars($db_error); ?></span></div>
        </div>
        <?php
    elseif ($db_success): ?>
        <div class="alert alert-success">
            <div class="alert-icon" style="background:#22c55e">✓</div>
            <div><strong>Connected!</strong><br><span style="font-size:11px">Database connection established successfully.</span></div>
        </div>
        <?php
    endif; ?>

        <form method="POST" action="?step=database">
            <div class="form-grid">
                <div class="form-group">
                    <label>Database Host</label>
                    <input type="text" name="host" value="<?php echo htmlspecialchars($_SESSION['db_config']['host']); ?>" required placeholder="127.0.0.1 or localhost">
                </div>
                <div class="form-group">
                    <label>Database Name</label>
                    <input type="text" name="database" value="<?php echo htmlspecialchars($_SESSION['db_config']['database']); ?>" required placeholder="my_database">
                </div>
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" name="username" value="<?php echo htmlspecialchars($_SESSION['db_config']['username']); ?>" required placeholder="db_user">
                </div>
                <div class="form-group">
                    <label>Password</label>
                    <input type="password" name="password" value="<?php echo htmlspecialchars($_SESSION['db_config']['password']); ?>" placeholder="••••••••">
                </div>
            </div>
            <div class="actions">
                <a href="?step=environment" class="btn-back">← Back</a>
                <div style="display:flex;gap:10px">
                    <button type="submit" class="btn btn-outline">Test Connection</button>
                    <?php if ($db_success): ?>
                    <a href="?step=account" class="btn btn-primary">Next Step →</a>
                    <?php
    endif; ?>
                </div>
            </div>
        </form>

<?php
elseif ($step === 'account'): ?>
        <!-- ════════ STEP 4: ACCOUNT + INSTALL ════════ -->
        <div id="setup-form">
            <div class="badge">Final Step</div>
            <h2>Admin Account</h2>
            <p class="desc">Create your admin login for the control panel.</p>

            <form id="installForm">
                <div class="form-group" style="margin-bottom:12px">
                    <label>Full Name</label>
                    <input type="text" name="name" required placeholder="Admin User">
                </div>
                <div class="form-group" style="margin-bottom:12px">
                    <label>Email Address</label>
                    <input type="email" name="email" required placeholder="admin@example.com">
                </div>
                <div class="form-group" style="margin-bottom:12px">
                    <label>Password</label>
                    <input type="password" name="password" required placeholder="Minimum 8 characters" minlength="8">
                </div>
                <div class="actions">
                    <a href="?step=database" class="btn-back">← Back</a>
                    <button type="submit" class="btn btn-primary">Install Now ⚡</button>
                </div>
            </form>
        </div>

        <!-- Progress UI (hidden until install starts) -->
        <div class="progress-wrap" id="progress-wrap">
            <div class="spinner" id="spinner"></div>
            <h2 id="prog-title">Installing...</h2>
            <p class="desc" id="prog-sub" style="margin-bottom:0">Please wait. Do not close this window.</p>
            <div class="prog-bar-wrap"><div class="prog-bar" id="prog-bar"></div></div>
            <div class="log-box" id="log-box"></div>
        </div>

        <script>
        document.getElementById('installForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            var fd = new FormData(this);
            var d = {};
            fd.forEach(function(v,k){ d[k] = v; });

            document.getElementById('setup-form').style.display = 'none';
            document.getElementById('progress-wrap').style.display = 'flex';

            var steps = [
                {name:'Generating .env file', pct:20, action:'gen_env'},
                {name:'Running migrations', pct:50, action:'migrate'},
                {name:'Seeding database', pct:75, action:'seed'},
                {name:'Creating admin account', pct:90, action:'create_admin'},
                {name:'Optimizing app', pct:100, action:'optimize'}
            ];

            function log(msg, isErr) {
                var box = document.getElementById('log-box');
                var el = document.createElement('div');
                if (isErr) el.className = 'err';
                el.textContent = '> ' + msg;
                box.appendChild(el);
                box.scrollTop = box.scrollHeight;
            }

            for (var i = 0; i < steps.length; i++) {
                var s = steps[i];
                document.getElementById('prog-title').textContent = s.name;
                document.getElementById('prog-bar').style.width = s.pct + '%';
                log('Running: ' + s.name + '...');

                try {
                    var body = JSON.parse(JSON.stringify(d));
                    body.action = s.action;
                    
                    var resp = await fetch('?step=process', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/json'},
                        body: JSON.stringify(body)
                    });
                    var result = await resp.json();
                    
                    if (!result.success) throw new Error(result.message || 'Failed');
                    log('Done: ' + s.name);
                } catch (err) {
                    log(err.message, true);
                    document.getElementById('prog-title').textContent = 'Installation Failed';
                    document.getElementById('spinner').style.borderTopColor = '#ef4444';
                    document.getElementById('spinner').style.animationPlayState = 'paused';
                    return;
                }
            }

            log('Installation complete!');
            setTimeout(function(){ window.location.href = '?step=finish'; }, 1200);
        });
        </script>

<?php
elseif ($step === 'finish'): ?>
        <!-- ════════ STEP 5: DONE ════════ -->
        <div style="text-align:center;display:flex;flex-direction:column;align-items:center;justify-content:center;flex:1">
            <div class="finish-icon">✓</div>
            <h2>Installation Successful!</h2>
            <p class="desc" style="max-width:360px;margin:8px auto 32px">Your application is configured and ready to use.</p>

            <div class="alert alert-warn" style="text-align:left;width:100%">
                <div class="alert-icon" style="background:#f59e0b">⚠</div>
                <div><strong>Security:</strong> Delete <code>install.php</code> and the <code>install/</code> folder now.</div>
            </div>
            <div class="alert alert-info" style="text-align:left;width:100%">
                <div class="alert-icon" style="background:#3b82f6">ℹ</div>
                <div><strong>Storage:</strong> If images don't show, create a symlink from <code>public/storage</code> → <code>storage/app/public</code> via cPanel File Manager.</div>
            </div>

            <div style="display:flex;gap:12px;width:100%;margin-top:16px">
                <a href="/" class="btn btn-outline" style="flex:1;justify-content:center">Visit Website</a>
                <a href="/admin/login" class="btn btn-primary" style="flex:1;justify-content:center">Admin Panel →</a>
            </div>
        </div>

<?php
endif; ?>

    </div>
</div>
</body>
</html>
