"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["resources_js_pages_Cart_vue"],{

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/Cart.vue?vue&type=script&setup=true&lang=js"
/*!****************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/Cart.vue?vue&type=script&setup=true&lang=js ***!
  \****************************************************************************************************************************************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _stores_cart__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/stores/cart */ "./resources/js/stores/cart.js");
/* harmony import */ var _stores_toast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/stores/toast */ "./resources/js/stores/toast.js");



var FREE_SHIPPING_THRESHOLD = 100;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Cart',
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var cartStore = (0,_stores_cart__WEBPACK_IMPORTED_MODULE_1__.useCartStore)();
    var toastStore = (0,_stores_toast__WEBPACK_IMPORTED_MODULE_2__.useToastStore)();
    var couponCode = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    var couponApplied = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var discount = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
    var shippingRemaining = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return Math.max(0, FREE_SHIPPING_THRESHOLD - cartStore.total);
    });
    var shippingProgress = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return Math.min(100, cartStore.total / FREE_SHIPPING_THRESHOLD * 100);
    });
    var shippingCost = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return cartStore.total >= FREE_SHIPPING_THRESHOLD ? 0 : 9.99;
    });
    var finalTotal = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return cartStore.total + shippingCost.value - discount.value;
    });
    function updateQty(id, qty) {
      cartStore.updateQuantity(id, qty);
    }
    function removeItem(item) {
      cartStore.removeItem(item.id);
      toastStore.info("".concat(item.name, " removed from cart"));
    }
    function applyCoupon() {
      if (couponCode.value.toUpperCase() === 'TWELVE26') {
        couponApplied.value = true;
        discount.value = cartStore.total * 0.15;
        toastStore.success('Coupon TWELVE26 applied! 15% off');
      } else {
        toastStore.error('Invalid coupon code');
      }
    }
    var __returned__ = {
      cartStore: cartStore,
      toastStore: toastStore,
      couponCode: couponCode,
      couponApplied: couponApplied,
      discount: discount,
      FREE_SHIPPING_THRESHOLD: FREE_SHIPPING_THRESHOLD,
      shippingRemaining: shippingRemaining,
      shippingProgress: shippingProgress,
      shippingCost: shippingCost,
      finalTotal: finalTotal,
      updateQty: updateQty,
      removeItem: removeItem,
      applyCoupon: applyCoupon,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed,
      get useCartStore() {
        return _stores_cart__WEBPACK_IMPORTED_MODULE_1__.useCartStore;
      },
      get useToastStore() {
        return _stores_toast__WEBPACK_IMPORTED_MODULE_2__.useToastStore;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ },

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/Cart.vue?vue&type=template&id=7908d3ae"
/*!*********************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/Cart.vue?vue&type=template&id=7908d3ae ***!
  \*********************************************************************************************************************************************************************************************************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }

var _hoisted_1 = {
  "class": "min-h-screen bg-background"
};
var _hoisted_2 = {
  "class": "bg-white border-b border-gray-100"
};
var _hoisted_3 = {
  "class": "max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-3"
};
var _hoisted_4 = {
  "class": "flex items-center gap-2 text-sm text-content-muted"
};
var _hoisted_5 = {
  "class": "max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10"
};
var _hoisted_6 = {
  key: 0,
  "class": "text-center py-20"
};
var _hoisted_7 = {
  "class": "text-content-muted mb-8"
};
var _hoisted_8 = {
  key: 0,
  "class": "bg-primary-50 rounded-xl p-4 mb-8 flex items-center gap-4"
};
var _hoisted_9 = {
  "class": "flex-1"
};
var _hoisted_10 = {
  "class": "text-sm font-medium text-primary-800"
};
var _hoisted_11 = {
  "class": "font-bold"
};
var _hoisted_12 = {
  "class": "w-full bg-primary-200 rounded-full h-2 mt-2"
};
var _hoisted_13 = {
  key: 1,
  "class": "bg-green-50 rounded-xl p-4 mb-8 flex items-center gap-3"
};
var _hoisted_14 = {
  "class": "lg:flex lg:gap-12"
};
var _hoisted_15 = {
  "class": "flex-1 space-y-4"
};
var _hoisted_16 = {
  "class": "w-20 h-20 sm:w-24 sm:h-24 rounded-xl overflow-hidden bg-gray-50 flex-shrink-0"
};
var _hoisted_17 = ["src", "alt"];
var _hoisted_18 = {
  "class": "flex-1 min-w-0"
};
var _hoisted_19 = {
  "class": "font-semibold text-content text-sm sm:text-base line-clamp-1"
};
var _hoisted_20 = {
  "class": "text-primary-600 font-bold mt-1"
};
var _hoisted_21 = {
  "class": "flex items-center border border-gray-200 rounded-xl overflow-hidden flex-shrink-0"
};
var _hoisted_22 = ["onClick"];
var _hoisted_23 = {
  "class": "w-10 h-9 flex items-center justify-center font-semibold text-sm border-x border-gray-200 bg-gray-50"
};
var _hoisted_24 = ["onClick"];
var _hoisted_25 = {
  "class": "hidden sm:block text-right flex-shrink-0 w-20"
};
var _hoisted_26 = {
  "class": "font-bold text-content"
};
var _hoisted_27 = ["onClick"];
var _hoisted_28 = {
  "class": "lg:w-96 mt-8 lg:mt-0"
};
var _hoisted_29 = {
  "class": "bg-white rounded-2xl border border-gray-100 p-6 sticky top-24"
};
var _hoisted_30 = {
  "class": "space-y-4 text-sm"
};
var _hoisted_31 = {
  "class": "flex justify-between"
};
var _hoisted_32 = {
  "class": "text-content-light"
};
var _hoisted_33 = {
  "class": "font-medium"
};
var _hoisted_34 = {
  "class": "flex gap-2"
};
var _hoisted_35 = {
  key: 0,
  "class": "text-xs text-green-600 font-medium mt-2 flex items-center gap-1"
};
var _hoisted_36 = {
  "class": "flex justify-between"
};
var _hoisted_37 = {
  key: 0,
  "class": "flex justify-between text-green-600"
};
var _hoisted_38 = {
  "class": "font-medium"
};
var _hoisted_39 = {
  "class": "border-t border-gray-100 pt-4 flex justify-between text-base font-bold text-content"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_router_link = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("router-link");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Breadcrumb "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("nav", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: "/",
    "class": "hover:text-primary-600 transition-colors"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return _toConsumableArray(_cache[1] || (_cache[1] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Home", -1 /* CACHED */)]));
    }),
    _: 1 /* STABLE */
  }), _cache[2] || (_cache[2] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-3.5 h-3.5",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M9 5l7 7-7 7"
  })], -1 /* CACHED */)), _cache[3] || (_cache[3] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "text-content font-medium"
  }, "Shopping Cart", -1 /* CACHED */))])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Empty Cart "), $setup.cartStore.items.length === 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_6, [_cache[5] || (_cache[5] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createStaticVNode)("<div class=\"inline-flex items-center justify-center w-24 h-24 rounded-full bg-gray-100 mb-6\"><svg class=\"w-10 h-10 text-gray-400\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\"><path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z\"></path></svg></div><h2 class=\"text-2xl font-heading font-bold text-content mb-3\">Your cart is empty</h2><p class=\"text-content-muted mb-8\">Looks like you haven&#39;t added anything to your cart yet.</p>", 3)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: "/products",
    "class": "btn-primary"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return _toConsumableArray(_cache[4] || (_cache[4] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Start Shopping", -1 /* CACHED */)]));
    }),
    _: 1 /* STABLE */
  })])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 1
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Cart Content "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", null, [_cache[18] || (_cache[18] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h1", {
    "class": "text-3xl font-heading font-bold text-content mb-2"
  }, "Shopping Cart", -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.cartStore.count) + " item" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.cartStore.count !== 1 ? 's' : '') + " in your cart", 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Free Shipping Progress "), $setup.shippingRemaining > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_8, [_cache[8] || (_cache[8] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-6 h-6 text-primary-600 flex-shrink-0",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M13 16V6a1 1 0 00-1-1H4a1 1 0 00-1 1v10a1 1 0 001 1h1m8-1a1 1 0 01-1 1H9m4-1V8a1 1 0 011-1h2.586a1 1 0 01.707.293l3.414 3.414a1 1 0 01.293.707V16a1 1 0 01-1 1h-1m-6-1a1 1 0 001 1h1M5 17a2 2 0 104 0m-4 0a2 2 0 114 0m6 0a2 2 0 104 0m-4 0a2 2 0 114 0"
  })], -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_10, [_cache[6] || (_cache[6] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Add ", -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_11, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.shippingRemaining.toFixed(2)), 1 /* TEXT */), _cache[7] || (_cache[7] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" more for free shipping!", -1 /* CACHED */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_12, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "bg-primary-600 h-2 rounded-full transition-all duration-500",
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)({
      width: $setup.shippingProgress + '%'
    })
  }, null, 4 /* STYLE */)])])])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_13, _toConsumableArray(_cache[9] || (_cache[9] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-5 h-5 text-green-600",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M5 13l4 4L19 7"
  })], -1 /* CACHED */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
    "class": "text-sm font-medium text-green-800"
  }, "You've qualified for free shipping! 🎉", -1 /* CACHED */)])))), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_14, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Items "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.cartStore.items, function (item) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
      key: item.id,
      "class": "bg-white rounded-2xl border border-gray-100 p-5 flex items-center gap-5 hover:shadow-sm transition-shadow"
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Image "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_16, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
      src: item.image || 'https://placehold.co/100x100/f5f5f4/a8a29e?text=No+Img',
      alt: item.name,
      "class": "w-full h-full object-cover"
    }, null, 8 /* PROPS */, _hoisted_17)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Info "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_18, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", _hoisted_19, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(item.name), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_20, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(parseFloat(item.price).toFixed(2)), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Quantity "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_21, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      onClick: function onClick($event) {
        return $setup.updateQty(item.id, item.quantity - 1);
      },
      "class": "w-9 h-9 flex items-center justify-center text-content-light hover:bg-gray-50 transition-colors"
    }, "−", 8 /* PROPS */, _hoisted_22), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_23, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(item.quantity), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      onClick: function onClick($event) {
        return $setup.updateQty(item.id, item.quantity + 1);
      },
      "class": "w-9 h-9 flex items-center justify-center text-content-light hover:bg-gray-50 transition-colors"
    }, "+", 8 /* PROPS */, _hoisted_24)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Total "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_25, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_26, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((item.price * item.quantity).toFixed(2)), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Remove "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      onClick: function onClick($event) {
        return $setup.removeItem(item);
      },
      "class": "text-gray-400 hover:text-red-500 transition-colors flex-shrink-0"
    }, _toConsumableArray(_cache[10] || (_cache[10] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
      "class": "w-5 h-5",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor"
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      "stroke-width": "2",
      d: "M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"
    })], -1 /* CACHED */)])), 8 /* PROPS */, _hoisted_27)]);
  }), 128 /* KEYED_FRAGMENT */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Order Summary "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_28, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_29, [_cache[17] || (_cache[17] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", {
    "class": "font-heading font-bold text-lg text-content mb-6"
  }, "Order Summary", -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_30, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_31, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_32, "Subtotal (" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.cartStore.count) + " items)", 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_33, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.cartStore.total.toFixed(2)), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Coupon "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_34, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    "onUpdate:modelValue": _cache[0] || (_cache[0] = function ($event) {
      return $setup.couponCode = $event;
    }),
    type: "text",
    placeholder: "Coupon code",
    "class": "flex-1 px-3 py-2 border border-gray-200 rounded-xl text-sm focus:border-primary-500 focus:ring-1 focus:ring-primary-500"
  }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.couponCode]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: $setup.applyCoupon,
    "class": "px-4 py-2 bg-gray-100 hover:bg-gray-200 rounded-xl text-sm font-medium text-content transition-colors"
  }, "Apply")]), $setup.couponApplied ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_35, [_cache[11] || (_cache[11] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-3.5 h-3.5",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M5 13l4 4L19 7"
  })], -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Coupon applied! -$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.discount.toFixed(2)), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_36, [_cache[12] || (_cache[12] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "text-content-light"
  }, "Shipping", -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)($setup.cartStore.total >= 100 ? 'text-green-600 font-medium' : 'font-medium')
  }, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.cartStore.total >= 100 ? 'Free' : '9.99'), 3 /* TEXT, CLASS */)]), $setup.couponApplied ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_37, [_cache[13] || (_cache[13] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Discount", -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_38, "-$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.discount.toFixed(2)), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_39, [_cache[14] || (_cache[14] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Total", -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.finalTotal.toFixed(2)), 1 /* TEXT */)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: "/checkout",
    "class": "btn-primary w-full mt-6 text-center block"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return _toConsumableArray(_cache[15] || (_cache[15] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Proceed to Checkout ", -1 /* CACHED */)]));
    }),
    _: 1 /* STABLE */
  }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: "/products",
    "class": "block text-center text-sm text-content-muted hover:text-primary-600 mt-4 transition-colors"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return _toConsumableArray(_cache[16] || (_cache[16] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Continue Shopping ", -1 /* CACHED */)]));
    }),
    _: 1 /* STABLE */
  })])])])])], 2112 /* STABLE_FRAGMENT, DEV_ROOT_FRAGMENT */))])]);
}

/***/ },

/***/ "./resources/js/pages/Cart.vue"
/*!*************************************!*\
  !*** ./resources/js/pages/Cart.vue ***!
  \*************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Cart_vue_vue_type_template_id_7908d3ae__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cart.vue?vue&type=template&id=7908d3ae */ "./resources/js/pages/Cart.vue?vue&type=template&id=7908d3ae");
/* harmony import */ var _Cart_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Cart.vue?vue&type=script&setup=true&lang=js */ "./resources/js/pages/Cart.vue?vue&type=script&setup=true&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_Cart_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_Cart_vue_vue_type_template_id_7908d3ae__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"resources/js/pages/Cart.vue"]])
/* hot reload */
if (false) // removed by dead control flow
{}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ },

/***/ "./resources/js/pages/Cart.vue?vue&type=script&setup=true&lang=js"
/*!************************************************************************!*\
  !*** ./resources/js/pages/Cart.vue?vue&type=script&setup=true&lang=js ***!
  \************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Cart_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Cart_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./Cart.vue?vue&type=script&setup=true&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/Cart.vue?vue&type=script&setup=true&lang=js");
 

/***/ },

/***/ "./resources/js/pages/Cart.vue?vue&type=template&id=7908d3ae"
/*!*******************************************************************!*\
  !*** ./resources/js/pages/Cart.vue?vue&type=template&id=7908d3ae ***!
  \*******************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Cart_vue_vue_type_template_id_7908d3ae__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_Cart_vue_vue_type_template_id_7908d3ae__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./Cart.vue?vue&type=template&id=7908d3ae */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/Cart.vue?vue&type=template&id=7908d3ae");


/***/ }

}]);
//# sourceMappingURL=resources_js_pages_Cart_vue.js.map