"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["resources_js_pages_ProductDetail_vue"],{

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/ProductCard.vue?vue&type=script&setup=true&lang=js"
/*!****************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/ProductCard.vue?vue&type=script&setup=true&lang=js ***!
  \****************************************************************************************************************************************************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _stores_cart__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @/stores/cart */ "./resources/js/stores/cart.js");
/* harmony import */ var _stores_wishlist__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/stores/wishlist */ "./resources/js/stores/wishlist.js");
/* harmony import */ var vue_toastification__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-toastification */ "./node_modules/vue-toastification/dist/index.mjs");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'ProductCard',
  props: {
    product: {
      type: Object,
      required: true
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var cartStore = (0,_stores_cart__WEBPACK_IMPORTED_MODULE_1__.useCartStore)();
    var wishlistStore = (0,_stores_wishlist__WEBPACK_IMPORTED_MODULE_2__.useWishlistStore)();
    var toast = (0,vue_toastification__WEBPACK_IMPORTED_MODULE_3__.useToast)();
    var imageFailed = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var wishlisted = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return wishlistStore.isInWishlist(props.product.id);
    });
    var displayImage = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      var _props$product$images;
      if (imageFailed.value) return 'https://placehold.co/400x500/f5f5f4/a8a29e?text=No+Image';
      var img = props.product.primary_image || props.product.image || ((_props$product$images = props.product.images) === null || _props$product$images === void 0 ? void 0 : _props$product$images[0]);
      if (!img) return 'https://placehold.co/400x500/f5f5f4/a8a29e?text=No+Image';
      if (img.startsWith('http')) return img;

      // Clean up path
      img = img.replace('/storage/', '');
      return "/storage/".concat(img);
    });
    var secondaryImage = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      var images = props.product.images;
      if (images && images.length > 1) {
        var img = images[1];
        if (img.startsWith('http')) return img;
        img = img.replace('/storage/', '');
        return "/storage/".concat(img);
      }
      return null;
    });
    var discountPercent = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      if (props.product.sale_price && props.product.price) {
        return Math.round((1 - props.product.sale_price / props.product.price) * 100);
      }
      return null;
    });
    var isNew = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      if (props.product.created_at) {
        var d = new Date(props.product.created_at);
        var daysOld = (Date.now() - d.getTime()) / (1000 * 60 * 60 * 24);
        return daysOld < 30;
      }
      return false;
    });
    var rating = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return props.product.avg_rating || props.product.rating || 4;
    });
    function addToCart() {
      cartStore.addItem({
        id: props.product.id,
        name: props.product.name,
        price: props.product.sale_price || props.product.price,
        image: displayImage.value,
        quantity: 1
      });
      toast.success("".concat(props.product.name, " added to cart!"));
    }
    function toggleWishlist() {
      wishlistStore.toggleWishlist(props.product);
    }
    function handleImageError() {
      imageFailed.value = true;
    }
    var __returned__ = {
      props: props,
      cartStore: cartStore,
      wishlistStore: wishlistStore,
      toast: toast,
      imageFailed: imageFailed,
      wishlisted: wishlisted,
      displayImage: displayImage,
      secondaryImage: secondaryImage,
      discountPercent: discountPercent,
      isNew: isNew,
      rating: rating,
      addToCart: addToCart,
      toggleWishlist: toggleWishlist,
      handleImageError: handleImageError,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get useCartStore() {
        return _stores_cart__WEBPACK_IMPORTED_MODULE_1__.useCartStore;
      },
      get useWishlistStore() {
        return _stores_wishlist__WEBPACK_IMPORTED_MODULE_2__.useWishlistStore;
      },
      get useToast() {
        return vue_toastification__WEBPACK_IMPORTED_MODULE_3__.useToast;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ },

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/ProductDetail.vue?vue&type=script&setup=true&lang=js"
/*!*************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/ProductDetail.vue?vue&type=script&setup=true&lang=js ***!
  \*************************************************************************************************************************************************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var vue_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue-router */ "./node_modules/vue-router/dist/vue-router.mjs");
/* harmony import */ var _stores_cart__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @/stores/cart */ "./resources/js/stores/cart.js");
/* harmony import */ var _stores_wishlist__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @/stores/wishlist */ "./resources/js/stores/wishlist.js");
/* harmony import */ var vue_toastification__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vue-toastification */ "./node_modules/vue-toastification/dist/index.mjs");
/* harmony import */ var _components_ProductCard_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/components/ProductCard.vue */ "./resources/js/components/ProductCard.vue");
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }






/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'ProductDetail',
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var route = (0,vue_router__WEBPACK_IMPORTED_MODULE_1__.useRoute)();
    var cartStore = (0,_stores_cart__WEBPACK_IMPORTED_MODULE_2__.useCartStore)();
    var wishlistStore = (0,_stores_wishlist__WEBPACK_IMPORTED_MODULE_3__.useWishlistStore)();
    var toast = (0,vue_toastification__WEBPACK_IMPORTED_MODULE_4__.useToast)();
    var product = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    var relatedProducts = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    var loading = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(true);
    var qty = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(1);
    var activeImageIndex = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
    var activeTab = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('description');
    var wishlisted = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return product.value ? wishlistStore.isInWishlist(product.value.id) : false;
    });
    var tabs = [{
      key: 'description',
      label: 'Description'
    }, {
      key: 'specs',
      label: 'Specifications'
    }, {
      key: 'reviews',
      label: 'Reviews'
    }];
    var galleryImages = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      if (!product.value) return [];
      var imgs = [];
      if (product.value.primary_image) imgs.push(resolveImage(product.value.primary_image));
      if (product.value.images) {
        product.value.images.forEach(function (img) {
          var resolved = resolveImage(img);
          if (!imgs.includes(resolved)) imgs.push(resolved);
        });
      }
      if (imgs.length === 0 && product.value.image) imgs.push(resolveImage(product.value.image));
      if (imgs.length === 0) imgs.push('https://placehold.co/600x600/f5f5f4/a8a29e?text=No+Image');
      return imgs;
    });
    var activeImage = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return galleryImages.value[activeImageIndex.value] || galleryImages.value[0];
    });
    var discountPercent = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      var _product$value, _product$value2;
      if ((_product$value = product.value) !== null && _product$value !== void 0 && _product$value.sale_price && (_product$value2 = product.value) !== null && _product$value2 !== void 0 && _product$value2.price) {
        return Math.round((1 - product.value.sale_price / product.value.price) * 100);
      }
      return null;
    });
    function resolveImage(img) {
      return img !== null && img !== void 0 && img.startsWith('http') ? img : "/storage/".concat(img);
    }
    function handleMainImageError(e) {
      e.target.src = 'https://placehold.co/600x600/f5f5f4/a8a29e?text=No+Image';
    }
    function addToCart() {
      cartStore.addItem({
        id: product.value.id,
        name: product.value.name,
        price: product.value.sale_price || product.value.price,
        image: activeImage.value,
        quantity: qty.value
      });
      toast.success("".concat(product.value.name, " added to cart!"));
    }
    function toggleWishlist() {
      if (product.value) {
        wishlistStore.toggleWishlist(product.value);
      }
    }
    function fetchProduct(_x) {
      return _fetchProduct.apply(this, arguments);
    }
    function _fetchProduct() {
      _fetchProduct = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(id) {
        var response, allResp, all, _t;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.p = _context.n) {
            case 0:
              loading.value = true;
              _context.p = 1;
              _context.n = 2;
              return fetch("/api/products/".concat(id));
            case 2:
              response = _context.v;
              _context.n = 3;
              return response.json();
            case 3:
              product.value = _context.v;
              _context.n = 4;
              return fetch('/api/products');
            case 4:
              allResp = _context.v;
              _context.n = 5;
              return allResp.json();
            case 5:
              all = _context.v;
              relatedProducts.value = all.filter(function (p) {
                return p.id !== product.value.id;
              }).slice(0, 4);
              _context.n = 7;
              break;
            case 6:
              _context.p = 6;
              _t = _context.v;
            case 7:
              _context.p = 7;
              loading.value = false;
              return _context.f(7);
            case 8:
              return _context.a(2);
          }
        }, _callee, null, [[1, 6, 7, 8]]);
      }));
      return _fetchProduct.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      fetchProduct(route.params.id);
      // Ensure wishlist is loaded
      wishlistStore.fetchWishlist();
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return route.params.id;
    }, function (newId) {
      if (newId) fetchProduct(newId);
    });
    var __returned__ = {
      route: route,
      cartStore: cartStore,
      wishlistStore: wishlistStore,
      toast: toast,
      product: product,
      relatedProducts: relatedProducts,
      loading: loading,
      qty: qty,
      activeImageIndex: activeImageIndex,
      activeTab: activeTab,
      wishlisted: wishlisted,
      tabs: tabs,
      galleryImages: galleryImages,
      activeImage: activeImage,
      discountPercent: discountPercent,
      resolveImage: resolveImage,
      handleMainImageError: handleMainImageError,
      addToCart: addToCart,
      toggleWishlist: toggleWishlist,
      fetchProduct: fetchProduct,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      get useRoute() {
        return vue_router__WEBPACK_IMPORTED_MODULE_1__.useRoute;
      },
      get useCartStore() {
        return _stores_cart__WEBPACK_IMPORTED_MODULE_2__.useCartStore;
      },
      get useWishlistStore() {
        return _stores_wishlist__WEBPACK_IMPORTED_MODULE_3__.useWishlistStore;
      },
      get useToast() {
        return vue_toastification__WEBPACK_IMPORTED_MODULE_4__.useToast;
      },
      ProductCard: _components_ProductCard_vue__WEBPACK_IMPORTED_MODULE_5__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ },

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/ProductCard.vue?vue&type=template&id=1a457ff8"
/*!*********************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/ProductCard.vue?vue&type=template&id=1a457ff8 ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }

var _hoisted_1 = {
  "class": "group bg-white rounded-2xl border border-gray-100 overflow-hidden hover:shadow-xl transition-all duration-300 hover:-translate-y-1 relative"
};
var _hoisted_2 = {
  "class": "absolute top-3 left-3 z-20 flex flex-col gap-1.5"
};
var _hoisted_3 = {
  key: 0,
  "class": "badge-new text-[10px]"
};
var _hoisted_4 = {
  key: 1,
  "class": "badge-sale text-[10px]"
};
var _hoisted_5 = {
  key: 2,
  "class": "badge-hot text-[10px]"
};
var _hoisted_6 = ["fill"];
var _hoisted_7 = {
  "class": "aspect-[3/4] bg-gray-50 overflow-hidden relative"
};
var _hoisted_8 = ["src", "alt"];
var _hoisted_9 = ["src", "alt"];
var _hoisted_10 = {
  "class": "absolute bottom-0 inset-x-0 p-3 translate-y-full group-hover:translate-y-0 transition-transform duration-300 z-10"
};
var _hoisted_11 = {
  "class": "p-4"
};
var _hoisted_12 = {
  key: 0,
  "class": "text-xs text-content-muted font-medium uppercase tracking-wider mb-1.5"
};
var _hoisted_13 = {
  "class": "font-semibold text-content text-sm group-hover:text-primary-600 transition-colors line-clamp-1"
};
var _hoisted_14 = {
  "class": "flex items-center gap-1 mt-2"
};
var _hoisted_15 = {
  "class": "flex gap-0.5"
};
var _hoisted_16 = {
  "class": "text-xs text-content-muted"
};
var _hoisted_17 = {
  "class": "flex items-baseline gap-2 mt-2.5"
};
var _hoisted_18 = {
  key: 0,
  "class": "text-sm text-content-muted line-through"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$props$product$categ;
  var _component_router_link = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("router-link");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Badges "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [$setup.isNew ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_3, "NEW")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.discountPercent ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_4, "-" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.discountPercent) + "%", 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $props.product.is_featured ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_5, "HOT")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Wishlist "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)($setup.toggleWishlist, ["prevent"]),
    "class": "absolute top-3 right-3 z-20 w-8 h-8 bg-white/90 backdrop-blur-sm rounded-full flex items-center justify-center text-gray-400 hover:text-red-500 hover:bg-white shadow-sm transition-all duration-200"
  }, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("svg", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["w-4 h-4", {
      'text-red-500': $setup.wishlisted
    }]),
    fill: $setup.wishlisted ? 'currentColor' : 'none',
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, _toConsumableArray(_cache[0] || (_cache[0] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"
  }, null, -1 /* CACHED */)])), 10 /* CLASS, PROPS */, _hoisted_6))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Image "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: "/products/".concat($props.product.slug || $props.product.id),
    "class": "block relative"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        src: $setup.displayImage,
        alt: $props.product.name,
        "class": "w-full h-full object-cover group-hover:scale-105 transition-transform duration-700",
        loading: "lazy",
        onError: $setup.handleImageError
      }, null, 40 /* PROPS, NEED_HYDRATION */, _hoisted_8), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Secondary Image on Hover "), $setup.secondaryImage ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("img", {
        key: 0,
        src: $setup.secondaryImage,
        alt: $props.product.name,
        "class": "absolute inset-0 w-full h-full object-cover opacity-0 group-hover:opacity-100 transition-opacity duration-500",
        loading: "lazy"
      }, null, 8 /* PROPS */, _hoisted_9)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Quick Add Overlay "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)($setup.addToCart, ["prevent"]),
        "class": "w-full py-2.5 bg-navy-900 hover:bg-navy-800 text-white text-sm font-semibold rounded-xl transition-colors flex items-center justify-center gap-2 shadow-lg"
      }, _toConsumableArray(_cache[1] || (_cache[1] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
        "class": "w-4 h-4",
        fill: "none",
        viewBox: "0 0 24 24",
        stroke: "currentColor"
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "2",
        d: "M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"
      })], -1 /* CACHED */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Quick Add ", -1 /* CACHED */)])))])])];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["to"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Info "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Category "), $props.product.category ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_12, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(typeof $props.product.category === 'string' ? $props.product.category : ((_$props$product$categ = $props.product.category) === null || _$props$product$categ === void 0 ? void 0 : _$props$product$categ.name) || ''), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Name "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: "/products/".concat($props.product.slug || $props.product.id),
    "class": "block"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", _hoisted_13, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($props.product.name), 1 /* TEXT */)];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["to"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Stars "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_14, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(5, function (i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
      key: i,
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["w-3.5 h-3.5", i <= $setup.rating ? 'text-accent' : 'text-gray-200']),
      fill: "currentColor",
      viewBox: "0 0 20 20"
    }, _toConsumableArray(_cache[2] || (_cache[2] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
      d: "M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"
    }, null, -1 /* CACHED */)])), 2 /* CLASS */);
  }), 64 /* STABLE_FRAGMENT */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_16, "(" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($props.product.reviews_count || 0) + ")", 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Price "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_17, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["text-lg font-bold", $props.product.sale_price ? 'text-red-500' : 'text-content'])
  }, " $" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($props.product.sale_price || $props.product.price), 3 /* TEXT, CLASS */), $props.product.sale_price ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_18, " $" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($props.product.price), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])]);
}

/***/ },

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/ProductDetail.vue?vue&type=template&id=43d28932"
/*!******************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/ProductDetail.vue?vue&type=template&id=43d28932 ***!
  \******************************************************************************************************************************************************************************************************************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }

var _hoisted_1 = {
  "class": "min-h-screen bg-background"
};
var _hoisted_2 = {
  "class": "bg-white border-b border-gray-100"
};
var _hoisted_3 = {
  "class": "max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-3"
};
var _hoisted_4 = {
  "class": "flex items-center gap-2 text-sm text-content-muted"
};
var _hoisted_5 = {
  "class": "text-content font-medium line-clamp-1"
};
var _hoisted_6 = {
  key: 0,
  "class": "max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12"
};
var _hoisted_7 = {
  "class": "max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12"
};
var _hoisted_8 = {
  "class": "lg:grid lg:grid-cols-2 lg:gap-16"
};
var _hoisted_9 = {
  "class": "aspect-square rounded-2xl overflow-hidden bg-gray-50 mb-4 relative group"
};
var _hoisted_10 = ["src", "alt"];
var _hoisted_11 = {
  "class": "absolute top-4 left-4 flex flex-col gap-2"
};
var _hoisted_12 = {
  key: 0,
  "class": "badge-sale"
};
var _hoisted_13 = {
  key: 1,
  "class": "badge-hot"
};
var _hoisted_14 = {
  key: 0,
  "class": "flex gap-3 overflow-x-auto hide-scrollbar"
};
var _hoisted_15 = ["onClick"];
var _hoisted_16 = ["src", "alt"];
var _hoisted_17 = {
  "class": "mt-8 lg:mt-0"
};
var _hoisted_18 = {
  key: 0,
  "class": "text-sm font-medium text-primary-600 mb-2"
};
var _hoisted_19 = {
  "class": "text-3xl lg:text-4xl font-heading font-bold text-content"
};
var _hoisted_20 = {
  "class": "flex items-center gap-3 mt-4"
};
var _hoisted_21 = {
  "class": "flex gap-0.5"
};
var _hoisted_22 = {
  "class": "text-sm text-content-muted"
};
var _hoisted_23 = {
  "class": "mt-6 flex items-baseline gap-3"
};
var _hoisted_24 = {
  key: 0,
  "class": "text-lg text-content-muted line-through"
};
var _hoisted_25 = {
  key: 1,
  "class": "text-sm font-semibold text-red-500 bg-red-50 px-2 py-0.5 rounded-md"
};
var _hoisted_26 = {
  key: 1,
  "class": "mt-6 text-content-light leading-relaxed"
};
var _hoisted_27 = {
  "class": "flex items-center gap-6 mb-8"
};
var _hoisted_28 = {
  "class": "flex items-center border border-gray-200 rounded-xl overflow-hidden"
};
var _hoisted_29 = {
  "class": "w-12 h-11 flex items-center justify-center font-semibold text-sm border-x border-gray-200 bg-gray-50"
};
var _hoisted_30 = {
  "class": "flex gap-3"
};
var _hoisted_31 = ["fill"];
var _hoisted_32 = {
  "class": "mt-16 border-t border-gray-100 pt-12"
};
var _hoisted_33 = {
  "class": "flex gap-1 bg-gray-100 rounded-xl p-1 w-fit mb-8"
};
var _hoisted_34 = ["onClick"];
var _hoisted_35 = {
  key: 0,
  "class": "prose prose-stone max-w-none"
};
var _hoisted_36 = ["innerHTML"];
var _hoisted_37 = {
  key: 1,
  "class": "max-w-2xl"
};
var _hoisted_38 = {
  key: 0
};
var _hoisted_39 = {
  "class": "font-medium text-content"
};
var _hoisted_40 = {
  "class": "text-content-light"
};
var _hoisted_41 = {
  key: 1,
  "class": "text-content-muted text-sm"
};
var _hoisted_42 = {
  key: 2,
  "class": "max-w-2xl"
};
var _hoisted_43 = {
  key: 0,
  "class": "mt-16 border-t border-gray-100 pt-12"
};
var _hoisted_44 = {
  "class": "grid grid-cols-2 md:grid-cols-4 gap-6"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$product, _$setup$product$categ;
  var _component_router_link = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("router-link");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Breadcrumb "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("nav", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: "/",
    "class": "hover:text-primary-600 transition-colors"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return _toConsumableArray(_cache[2] || (_cache[2] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Home", -1 /* CACHED */)]));
    }),
    _: 1 /* STABLE */
  }), _cache[4] || (_cache[4] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-3.5 h-3.5",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M9 5l7 7-7 7"
  })], -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: "/products",
    "class": "hover:text-primary-600 transition-colors"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return _toConsumableArray(_cache[3] || (_cache[3] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Products", -1 /* CACHED */)]));
    }),
    _: 1 /* STABLE */
  }), _cache[5] || (_cache[5] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-3.5 h-3.5",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M9 5l7 7-7 7"
  })], -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(((_$setup$product = $setup.product) === null || _$setup$product === void 0 ? void 0 : _$setup$product.name) || 'Loading...'), 1 /* TEXT */)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Loading "), $setup.loading ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_6, _toConsumableArray(_cache[6] || (_cache[6] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createStaticVNode)("<div class=\"lg:grid lg:grid-cols-2 lg:gap-16\"><div class=\"shimmer-loader aspect-square rounded-2xl\"></div><div class=\"mt-8 lg:mt-0 space-y-4\"><div class=\"shimmer-loader h-8 w-2/3 rounded-lg\"></div><div class=\"shimmer-loader h-6 w-1/4 rounded-lg\"></div><div class=\"shimmer-loader h-24 w-full rounded-lg\"></div><div class=\"shimmer-loader h-12 w-1/2 rounded-xl\"></div></div></div>", 1)])))) : $setup.product ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 1
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Product Content "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Image Gallery "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
    src: $setup.activeImage,
    alt: $setup.product.name,
    "class": "w-full h-full object-cover group-hover:scale-105 transition-transform duration-500",
    onError: $setup.handleMainImageError
  }, null, 40 /* PROPS, NEED_HYDRATION */, _hoisted_10), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Badges "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [$setup.discountPercent ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_12, "-" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.discountPercent) + "%", 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.product.is_featured ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_13, "Popular")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Thumbnails "), $setup.galleryImages.length > 1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_14, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.galleryImages, function (img, idx) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("button", {
      key: idx,
      onClick: function onClick($event) {
        return $setup.activeImageIndex = idx;
      },
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(['w-20 h-20 rounded-xl overflow-hidden bg-gray-50 border-2 flex-shrink-0 transition-all', $setup.activeImageIndex === idx ? 'border-primary-500 ring-2 ring-primary-200' : 'border-transparent hover:border-gray-300'])
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
      src: img,
      alt: "".concat($setup.product.name, " ").concat(idx + 1),
      "class": "w-full h-full object-cover"
    }, null, 8 /* PROPS */, _hoisted_16)], 10 /* CLASS, PROPS */, _hoisted_15);
  }), 128 /* KEYED_FRAGMENT */))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Product Info "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_17, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Category "), $setup.product.category ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(typeof $setup.product.category === 'string' ? $setup.product.category : ((_$setup$product$categ = $setup.product.category) === null || _$setup$product$categ === void 0 ? void 0 : _$setup$product$categ.name) || ''), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Name "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h1", _hoisted_19, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.product.name), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Rating "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_20, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_21, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(5, function (i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
      key: i,
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["w-5 h-5", i <= ($setup.product.avg_rating || 4) ? 'text-accent' : 'text-gray-200']),
      fill: "currentColor",
      viewBox: "0 0 20 20"
    }, _toConsumableArray(_cache[7] || (_cache[7] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
      d: "M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"
    }, null, -1 /* CACHED */)])), 2 /* CLASS */);
  }), 64 /* STABLE_FRAGMENT */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_22, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.product.reviews_count || 0) + " reviews", 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Price "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_23, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["text-3xl font-bold", $setup.product.sale_price ? 'text-red-500' : 'text-content'])
  }, " $" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.product.sale_price || $setup.product.price), 3 /* TEXT, CLASS */), $setup.product.sale_price ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_24, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.product.price), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.discountPercent ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_25, "Save " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.discountPercent) + "%", 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Short Description "), $setup.product.short_description ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_26, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.product.short_description), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), _cache[13] || (_cache[13] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("hr", {
    "class": "my-8 border-gray-100"
  }, null, -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Quantity "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_27, [_cache[10] || (_cache[10] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "text-sm font-medium text-content"
  }, "Quantity", -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_28, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $setup.qty = Math.max(1, $setup.qty - 1);
    }),
    "class": "w-11 h-11 flex items-center justify-center text-content-light hover:bg-gray-50 transition-colors"
  }, _toConsumableArray(_cache[8] || (_cache[8] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-4 h-4",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M20 12H4"
  })], -1 /* CACHED */)]))), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_29, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.qty), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: _cache[1] || (_cache[1] = function ($event) {
      return $setup.qty++;
    }),
    "class": "w-11 h-11 flex items-center justify-center text-content-light hover:bg-gray-50 transition-colors"
  }, _toConsumableArray(_cache[9] || (_cache[9] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-4 h-4",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M12 4v16m8-8H4"
  })], -1 /* CACHED */)])))])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Actions "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_30, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: $setup.addToCart,
    "class": "btn-primary btn-lg flex-1 group"
  }, _toConsumableArray(_cache[11] || (_cache[11] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    "class": "w-5 h-5 mr-2",
    fill: "none",
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"
  })], -1 /* CACHED */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add to Cart ", -1 /* CACHED */)]))), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: $setup.toggleWishlist,
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(['btn-outline !px-4', $setup.wishlisted ? '!border-red-300 !text-red-500 !bg-red-50' : ''])
  }, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("svg", {
    "class": "w-5 h-5",
    fill: $setup.wishlisted ? 'currentColor' : 'none',
    viewBox: "0 0 24 24",
    stroke: "currentColor"
  }, _toConsumableArray(_cache[12] || (_cache[12] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    "stroke-linecap": "round",
    "stroke-linejoin": "round",
    "stroke-width": "2",
    d: "M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"
  }, null, -1 /* CACHED */)])), 8 /* PROPS */, _hoisted_31))], 2 /* CLASS */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Trust "), _cache[14] || (_cache[14] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createStaticVNode)("<div class=\"mt-8 grid grid-cols-2 gap-4\"><div class=\"flex items-center gap-2 text-xs text-content-muted\"><svg class=\"w-4 h-4 text-primary-500\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\"><path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M5 13l4 4L19 7\"></path></svg> Free shipping over $100 </div><div class=\"flex items-center gap-2 text-xs text-content-muted\"><svg class=\"w-4 h-4 text-primary-500\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\"><path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15\"></path></svg> 30-day returns </div><div class=\"flex items-center gap-2 text-xs text-content-muted\"><svg class=\"w-4 h-4 text-primary-500\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\"><path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z\"></path></svg> Secure checkout </div><div class=\"flex items-center gap-2 text-xs text-content-muted\"><svg class=\"w-4 h-4 text-primary-500\" fill=\"none\" viewBox=\"0 0 24 24\" stroke=\"currentColor\"><path stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"2\" d=\"M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z\"></path></svg> 24/7 support </div></div>", 1))])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Tabs "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_32, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_33, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.tabs, function (tab) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      key: tab.key,
      onClick: function onClick($event) {
        return $setup.activeTab = tab.key;
      },
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(['px-6 py-2.5 rounded-lg text-sm font-medium transition-all duration-200', $setup.activeTab === tab.key ? 'bg-white text-content shadow-sm' : 'text-content-light hover:text-content'])
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(tab.label), 11 /* TEXT, CLASS, PROPS */, _hoisted_34);
  }), 64 /* STABLE_FRAGMENT */))]), $setup.activeTab === 'description' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_35, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    innerHTML: $setup.product.description || '<p>No description available.</p>'
  }, null, 8 /* PROPS */, _hoisted_36)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.activeTab === 'specs' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_37, [$setup.product.specifications && $setup.product.specifications.length ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_38, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.product.specifications, function (spec, idx) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
      key: idx,
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(['flex justify-between py-3 text-sm', idx % 2 === 0 ? 'bg-gray-50 px-4 rounded-lg' : 'px-4'])
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_39, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(spec.key), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_40, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(spec.value), 1 /* TEXT */)], 2 /* CLASS */);
  }), 128 /* KEYED_FRAGMENT */))])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_41, "No specifications available."))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.activeTab === 'reviews' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_42, _toConsumableArray(_cache[15] || (_cache[15] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
    "class": "text-content-muted text-sm"
  }, "Customer reviews coming soon.", -1 /* CACHED */)])))) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Related Products "), $setup.relatedProducts.length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_43, [_cache[16] || (_cache[16] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", {
    "class": "section-title mb-8"
  }, "You May Also Like", -1 /* CACHED */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_44, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.relatedProducts, function (p) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["ProductCard"], {
      key: p.id,
      product: p
    }, null, 8 /* PROPS */, ["product"]);
  }), 128 /* KEYED_FRAGMENT */))])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])], 2112 /* STABLE_FRAGMENT, DEV_ROOT_FRAGMENT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]);
}

/***/ },

/***/ "./resources/js/components/ProductCard.vue"
/*!*************************************************!*\
  !*** ./resources/js/components/ProductCard.vue ***!
  \*************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ProductCard_vue_vue_type_template_id_1a457ff8__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProductCard.vue?vue&type=template&id=1a457ff8 */ "./resources/js/components/ProductCard.vue?vue&type=template&id=1a457ff8");
/* harmony import */ var _ProductCard_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ProductCard.vue?vue&type=script&setup=true&lang=js */ "./resources/js/components/ProductCard.vue?vue&type=script&setup=true&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_ProductCard_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_ProductCard_vue_vue_type_template_id_1a457ff8__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"resources/js/components/ProductCard.vue"]])
/* hot reload */
if (false) // removed by dead control flow
{}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ },

/***/ "./resources/js/pages/ProductDetail.vue"
/*!**********************************************!*\
  !*** ./resources/js/pages/ProductDetail.vue ***!
  \**********************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ProductDetail_vue_vue_type_template_id_43d28932__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProductDetail.vue?vue&type=template&id=43d28932 */ "./resources/js/pages/ProductDetail.vue?vue&type=template&id=43d28932");
/* harmony import */ var _ProductDetail_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ProductDetail.vue?vue&type=script&setup=true&lang=js */ "./resources/js/pages/ProductDetail.vue?vue&type=script&setup=true&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_ProductDetail_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_ProductDetail_vue_vue_type_template_id_43d28932__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"resources/js/pages/ProductDetail.vue"]])
/* hot reload */
if (false) // removed by dead control flow
{}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ },

/***/ "./resources/js/components/ProductCard.vue?vue&type=script&setup=true&lang=js"
/*!************************************************************************************!*\
  !*** ./resources/js/components/ProductCard.vue?vue&type=script&setup=true&lang=js ***!
  \************************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ProductCard_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ProductCard_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./ProductCard.vue?vue&type=script&setup=true&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/ProductCard.vue?vue&type=script&setup=true&lang=js");
 

/***/ },

/***/ "./resources/js/pages/ProductDetail.vue?vue&type=script&setup=true&lang=js"
/*!*********************************************************************************!*\
  !*** ./resources/js/pages/ProductDetail.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ProductDetail_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ProductDetail_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./ProductDetail.vue?vue&type=script&setup=true&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/ProductDetail.vue?vue&type=script&setup=true&lang=js");
 

/***/ },

/***/ "./resources/js/components/ProductCard.vue?vue&type=template&id=1a457ff8"
/*!*******************************************************************************!*\
  !*** ./resources/js/components/ProductCard.vue?vue&type=template&id=1a457ff8 ***!
  \*******************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ProductCard_vue_vue_type_template_id_1a457ff8__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ProductCard_vue_vue_type_template_id_1a457ff8__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./ProductCard.vue?vue&type=template&id=1a457ff8 */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/ProductCard.vue?vue&type=template&id=1a457ff8");


/***/ },

/***/ "./resources/js/pages/ProductDetail.vue?vue&type=template&id=43d28932"
/*!****************************************************************************!*\
  !*** ./resources/js/pages/ProductDetail.vue?vue&type=template&id=43d28932 ***!
  \****************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ProductDetail_vue_vue_type_template_id_43d28932__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ProductDetail_vue_vue_type_template_id_43d28932__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./ProductDetail.vue?vue&type=template&id=43d28932 */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/pages/ProductDetail.vue?vue&type=template&id=43d28932");


/***/ }

}]);
//# sourceMappingURL=resources_js_pages_ProductDetail_vue.js.map