/**
 * Vue 3 E-Commerce Application
 * Bootstrap file for Laravel + Vue 3 integration
 */

import './bootstrap';
import { createApp } from 'vue';
import { createPinia } from 'pinia';
import router from './router';
import App from './App.vue';

// Create Pinia store
const pinia = createPinia();

// Create Vue app
const app = createApp(App);

// Use plugins
// Use plugins
app.use(pinia);
app.use(router);

import Toast from 'vue-toastification';
import 'vue-toastification/dist/index.css';

const options = {
    position: 'bottom-right',
    timeout: 3000,
    closeOnClick: true,
    pauseOnFocusLoss: true,
    pauseOnHover: true,
    draggable: true,
    draggablePercent: 0.6,
    showCloseButtonOnHover: false,
    hideProgressBar: true,
    closeButton: 'button',
    icon: true,
    rtl: false
};

app.use(Toast, options);

// Global error handler
app.config.errorHandler = (err, instance, info) => {
    console.error('Global error:', err);
    console.log('Error info:', info);
};

// Mount app
app.mount('#app');
