import { createRouter, createWebHistory } from 'vue-router';

// Route components (lazy-loaded)
const Home = () => import('../pages/Home.vue');
const Products = () => import('../pages/Products.vue');
const ProductDetail = () => import('../pages/ProductDetail.vue');
const Cart = () => import('../pages/Cart.vue');
const Checkout = () => import('../pages/Checkout.vue');

const routes = [
    {
        path: '/',
        name: 'home',
        component: Home,
        meta: { title: 'Home' }
    },
    {
        path: '/products',
        name: 'products',
        component: Products,
        meta: { title: 'Products' }
    },
    {
        path: '/products/:id',
        name: 'product-detail',
        component: ProductDetail,
        meta: { title: 'Product Details' }
    },
    {
        path: '/category/:slug',
        name: 'category',
        component: () => import('../pages/Category.vue'),
        meta: { title: 'Category' }
    },
    {
        path: '/cart',
        name: 'cart',
        component: Cart,
        meta: { title: 'Shopping Cart' }
    },
    {
        path: '/orders',
        name: 'orders',
        component: () => import('../pages/Orders.vue'),
        meta: { title: 'My Orders' }
    },
    {
        path: '/checkout',
        name: 'checkout',
        component: Checkout,
        meta: { title: 'Checkout' }
    },
    {
        path: '/wishlist',
        name: 'wishlist',
        component: () => import('../pages/Wishlist.vue'),
        meta: { title: 'My Wishlist' }
    },
    {
        path: '/settings',
        name: 'settings',
        component: () => import('../pages/Settings.vue'),
        meta: { title: 'Account Settings' }
    },
    // Blog Routes
    {
        path: '/blog',
        name: 'blog',
        component: () => import('../pages/Blog.vue'),
        meta: { title: 'Our Blog' }
    },
    {
        path: '/blog/:slug',
        name: 'blog-post',
        component: () => import('../pages/BlogPost.vue'),
        meta: { title: 'Blog Post' }
    },
    // Footer Pages
    {
        path: '/contact',
        name: 'contact',
        component: () => import('../pages/Contact.vue'),
        meta: { title: 'Contact Us' }
    },
    {
        path: '/faq',
        name: 'faq',
        component: () => import('../pages/Faq.vue'),
        meta: { title: 'FAQs' }
    },
    {
        path: '/shipping',
        name: 'shipping',
        component: () => import('../pages/StaticPage.vue'),
        props: { title: 'Shipping & Delivery', type: 'shipping' },
        meta: { title: 'Shipping Policy' }
    },
    {
        path: '/returns',
        name: 'returns',
        component: () => import('../pages/StaticPage.vue'),
        props: { title: 'Returns & Exchanges', type: 'returns' },
        meta: { title: 'Return Policy' }
    },
    {
        path: '/privacy',
        name: 'privacy',
        component: () => import('../pages/StaticPage.vue'),
        props: { title: 'Privacy Policy', type: 'privacy' },
        meta: { title: 'Privacy Policy' }
    },
    {
        path: '/terms',
        name: 'terms',
        component: () => import('../pages/StaticPage.vue'),
        props: { title: 'Terms of Service', type: 'terms' },
        meta: { title: 'Terms of Service' }
    },
    {
        path: '/lookbook',
        name: 'lookbook',
        component: () => import('../pages/Lookbook.vue'),
        meta: { title: 'Lookbook' }
    },
];

const router = createRouter({
    history: createWebHistory(),
    routes,
    scrollBehavior(to, from, savedPosition) {
        if (savedPosition) {
            return savedPosition;
        } else {
            return { top: 0 };
        }
    },
});

// Navigation guards
router.beforeEach((to, from, next) => {
    // Update document title
    document.title = to.meta.title ? `${to.meta.title} - Laravel E-Commerce` : 'Laravel E-Commerce';
    next();
});

export default router;
