import { defineStore } from 'pinia';
import { ref } from 'vue';

export const useToastStore = defineStore('toast', () => {
    const toasts = ref([]);
    let nextId = 0;

    function addToast(message, type = 'success', duration = 3500) {
        const id = nextId++;
        toasts.value.push({ id, message, type, visible: true });

        setTimeout(() => {
            removeToast(id);
        }, duration);
    }

    function removeToast(id) {
        const index = toasts.value.findIndex(t => t.id === id);
        if (index !== -1) {
            toasts.value[index].visible = false;
            setTimeout(() => {
                toasts.value = toasts.value.filter(t => t.id !== id);
            }, 400);
        }
    }

    function success(message) { addToast(message, 'success'); }
    function error(message) { addToast(message, 'error', 5000); }
    function info(message) { addToast(message, 'info'); }

    return { toasts, addToast, removeToast, success, error, info };
});
