<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice #{{ $order->number }} - Twelve Clothing</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        @media print {
            .no-print { display: none !important; }
            body { background: white; margin: 0; padding: 0; }
            .shadow-lg { box-shadow: none !important; }
            .border { border-color: #e5e7eb !important; }
        }
    </style>
</head>
<body class="bg-gray-100 py-10 print:py-0 text-gray-800">

    <div class="max-w-4xl mx-auto bg-white p-12 shadow-lg rounded-xl print:rounded-none print:shadow-none print:max-w-none">
        
        <!-- Header -->
        <div class="flex justify-between items-start mb-12 border-b border-gray-100 pb-8">
            <div>
                <div class="flex items-center gap-3 mb-2">
                    <div class="w-10 h-10 bg-indigo-600 flex items-center justify-center text-white font-bold text-xl rounded-lg">7</div>
                    <div class="leading-tight">
                        <h1 class="font-bold text-2xl tracking-widest text-gray-900">TWELVE</h1>
                        <p class="text-[0.6rem] tracking-[0.3em] font-medium text-gray-500 uppercase">CLOTHING</p>
                    </div>
                </div>
                <p class="text-sm text-gray-500 mt-4">123 Fashion Avenue, Gulshan 1</p>
                <p class="text-sm text-gray-500">Dhaka, Bangladesh</p>
                <p class="text-sm text-gray-500">support@twelveclothing.com</p>
            </div>
            <div class="text-right">
                <h2 class="text-4xl font-extrabold text-indigo-600 tracking-tight">INVOICE</h2>
                <p class="text-gray-500 font-medium mt-1">#{{ $order->number }}</p>
                <div class="mt-4 space-y-1">
                    <p class="text-sm"><span class="text-gray-500 w-24 inline-block">Date:</span> <span class="font-semibold">{{ $order->created_at->format('M d, Y') }}</span></p>
                    <p class="text-sm"><span class="text-gray-500 w-24 inline-block">Status:</span> 
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium uppercase {{ $order->status === 'paid' || $order->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                            {{ $order->status }}
                        </span>
                    </p>
                </div>
            </div>
        </div>

        <!-- Billing & Shipping -->
        <div class="grid grid-cols-2 gap-12 mb-12">
            <div>
                <h3 class="text-xs font-bold text-gray-400 uppercase tracking-wider mb-4 border-b pb-2">Bill To</h3>
                <p class="font-bold text-lg text-gray-900">{{ $order->user ? $order->user->name : ($order->first_name . ' ' . $order->last_name) }}</p>
                <p class="text-gray-600 mt-1">{{ $order->user->email ?? $order->email }}</p>
                <p class="text-gray-600">{{ $order->phone }}</p>
            </div>
            <div>
                <h3 class="text-xs font-bold text-gray-400 uppercase tracking-wider mb-4 border-b pb-2">Ship To</h3>
                <p class="text-gray-600 leading-relaxed">
                    {{ $order->shipping_address ?? $order->address }}<br>
                    {{ $order->city }}, {{ $order->postal_code }}<br>
                    Bangladesh
                </p>
            </div>
        </div>

        <!-- Order Items -->
        <div class="mb-12">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="text-xs font-semibold text-gray-500 border-b-2 border-gray-100 uppercase tracking-wider">
                        <th class="py-3 pr-4">Item Description</th>
                        <th class="py-3 px-4 text-center">Qty</th>
                        <th class="py-3 px-4 text-right">Unit Price</th>
                        <th class="py-3 pl-4 text-right">Total</th>
                    </tr>
                </thead>
                <tbody class="text-sm divide-y divide-gray-50">
                    @foreach($order->items as $item)
                    <tr>
                        <td class="py-4 pr-4">
                            <p class="font-semibold text-gray-900">{{ $item->product->name ?? 'Product Item' }}</p>
                            @if(isset($item->variation_options) && count($item->variation_options))
                                <p class="text-xs text-gray-500 mt-0.5">
                                    {{ implode(', ', $item->variation_options) }}
                                </p>
                            @endif
                        </td>
                        <td class="py-4 px-4 text-center font-medium">{{ $item->quantity }}</td>
                        <td class="py-4 px-4 text-right text-gray-600">{{ config('app.currency_symbol', '৳') }}{{ number_format($item->unit_price, 2) }}</td>
                        <td class="py-4 pl-4 text-right font-bold text-gray-900">{{ config('app.currency_symbol', '৳') }}{{ number_format($item->unit_price * $item->quantity, 2) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Totals -->
        <div class="flex justify-end mb-12">
            <div class="w-72 space-y-3">
                <div class="flex justify-between text-sm text-gray-600">
                    <span>Subtotal</span>
                    <span class="font-medium">{{ config('app.currency_symbol', '৳') }}{{ number_format($order->subtotal ?? $order->total_price, 2) }}</span>
                </div>
                @if($order->shipping_cost > 0)
                <div class="flex justify-between text-sm text-gray-600">
                    <span>Shipping</span>
                    <span class="font-medium">{{ config('app.currency_symbol', '৳') }}{{ number_format($order->shipping_cost, 2) }}</span>
                </div>
                @endif
                @if($order->tax > 0)
                <div class="flex justify-between text-sm text-gray-600">
                    <span>Tax (VAT)</span>
                    <span class="font-medium">{{ config('app.currency_symbol', '৳') }}{{ number_format($order->tax, 2) }}</span>
                </div>
                @endif
                <div class="flex justify-between text-lg font-bold text-indigo-600 border-t-2 border-indigo-100 pt-3 mt-3">
                    <span>Total</span>
                    <span>{{ config('app.currency_symbol', '৳') }}{{ number_format($order->total_price, 2) }}</span>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="border-t border-gray-100 pt-8 text-center">
            <h4 class="font-bold text-gray-900 text-sm mb-2">Thank you for your business!</h4>
            <p class="text-sm text-gray-500 mb-6">If you have any questions about this invoice, please contact support@twelveclothing.com</p>
            <div class="text-xs text-gray-400">
                &copy; {{ date('Y') }} Twelve Clothing. All rights reserved.
            </div>
        </div>

        <!-- Actions -->
        <div class="mt-8 text-center no-print space-x-4">
            <button onclick="window.print()" class="inline-flex items-center gap-2 bg-indigo-600 text-white px-6 py-2.5 rounded-lg font-medium hover:bg-indigo-700 transition shadow-sm">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z" /></svg>
                Print Invoice
            </button>
            <button onclick="window.print()" class="inline-flex items-center gap-2 bg-white text-gray-700 border border-gray-300 px-6 py-2.5 rounded-lg font-medium hover:bg-gray-50 transition shadow-sm">
                <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" /></svg>
                Download PDF
            </button>
        </div>

    </div>

</body>
</html>
