@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold mb-8 text-gray-800">Latest Blog Posts</h1> // Tailwind classes
    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        @foreach($posts as $post)
        <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">
            @if($post->featured_image)
                <img src="{{ Storage::url($post->featured_image) }}" alt="{{ $post->title }}" class="w-full h-48 object-cover">
            @else
                <div class="w-full h-48 bg-gray-200 flex items-center justify-center text-gray-400">
                    <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                </div>
            @endif
            
            <div class="p-6">
                <div class="text-sm text-gray-500 mb-2">{{ $post->published_at ? $post->published_at->format('M d, Y') : 'Draft' }}</div>
                <h2 class="text-xl font-bold mb-2 text-gray-900">
                    <a href="{{ route('blog.show', $post->slug) }}" class="hover:text-amber-600 transition-colors">
                        {{ $post->title }}
                    </a>
                </h2>
                <div class="text-gray-600 mb-4 line-clamp-3">
                    {!! Str::limit(strip_tags($post->content), 150) !!}
                </div>
                <a href="{{ route('blog.show', $post->slug) }}" class="inline-block text-amber-600 font-semibold hover:underline">Read More &rarr;</a>
            </div>
        </div>
        @endforeach
    </div>

    <div class="mt-8">
        {{ $posts->links() }}
    </div>
</div>
@endsection
