@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <a href="{{ route('blog.index') }}" class="inline-flex items-center text-gray-600 hover:text-amber-600 mb-6 transition-colors">
        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
        Back to Blog
    </a>

    <article class="bg-white rounded-xl shadow-sm overflow-hidden p-8 border border-gray-100">
        <header class="mb-8">
            <h1 class="text-4xl font-bold text-gray-900 mb-4">{{ $post->title }}</h1>
            <div class="flex items-center text-gray-500 text-sm">
                <span class="mr-4">By {{ $post->author->name ?? 'Admin' }}</span>
                <span>{{ $post->published_at ? $post->published_at->format('F d, Y') : 'Draft' }}</span>
            </div>
        </header>

        @if($post->featured_image)
            <img src="{{ Storage::url($post->featured_image) }}" alt="{{ $post->title }}" class="w-full h-96 object-cover rounded-lg mb-8 shadow-md">
        @endif

        <div class="prose prose-lg max-w-none text-gray-700">
            {!! $post->content !!}
        </div>
    </article>
</div>
@endsection
