<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
    <!-- Total Revenue Card -->
    <!-- Total Revenue Card -->
    <div class="bg-white rounded-2xl p-6 border border-gray-100 shadow-sm hover:shadow-md transition-shadow duration-300 animate-fade-in-up" style="animation-delay: 0.1s;">
        <div class="flex justify-between items-start">
            <div>
                <p class="text-gray-500 text-sm font-medium mb-1">Total Revenue</p>
                <h3 class="text-3xl font-bold text-gray-800">{{ $revenue['value'] }}</h3>
            </div>
            <div class="bg-indigo-50 p-2 rounded-lg">
                <x-heroicon-o-currency-dollar class="w-6 h-6 text-indigo-500" />
            </div>
        </div>
        <div class="mt-4 flex items-center gap-2">
            <span class="{{ $revenue['growth'] >= 0 ? 'text-green-500 bg-green-50' : 'text-red-500 bg-red-50' }} text-xs font-bold px-2 py-1 rounded-full flex items-center">
                @if($revenue['growth'] >= 0)
                    <x-heroicon-s-arrow-up class="w-3 h-3 mr-1" />
                @else
                    <x-heroicon-s-arrow-down class="w-3 h-3 mr-1" />
                @endif
                {{ abs($revenue['growth']) }}%
            </span>
            <span class="text-gray-400 text-xs">vs last month</span>
        </div>
    </div>

    <!-- Total Orders Card -->
    <div class="bg-white rounded-2xl p-6 border border-gray-100 shadow-sm hover:shadow-md transition-shadow duration-300 animate-fade-in-up" style="animation-delay: 0.2s;">
        <div class="flex justify-between items-start">
            <div>
                <p class="text-gray-500 text-sm font-medium mb-1">Total Orders</p>
                <h3 class="text-3xl font-bold text-gray-800">{{ $orders['value'] }}</h3>
            </div>
            <div class="bg-orange-100 p-2 rounded-lg">
                <x-heroicon-o-shopping-bag class="w-6 h-6 text-orange-500" />
            </div>
        </div>
        <div class="mt-4 flex items-center gap-2">
            <span class="{{ $orders['growth'] >= 0 ? 'text-green-500 bg-green-50' : 'text-red-500 bg-red-50' }} text-xs font-bold px-2 py-1 rounded-full flex items-center">
                @if($orders['growth'] >= 0)
                    <x-heroicon-s-arrow-up class="w-3 h-3 mr-1" />
                @else
                    <x-heroicon-s-arrow-down class="w-3 h-3 mr-1" />
                @endif
                {{ abs($orders['growth']) }}%
            </span>
            <span class="text-gray-400 text-xs">vs last month</span>
        </div>
    </div>

    <!-- Top Product Card -->
    <div class="bg-white rounded-2xl p-6 border border-gray-100 shadow-sm hover:shadow-md transition-shadow duration-300 animate-fade-in-up" style="animation-delay: 0.3s;">
        <div class="flex justify-between items-start">
            <div>
                <p class="text-gray-500 text-sm font-medium mb-1">Top Best Seller</p>
                <h3 class="text-xl font-bold text-gray-800 line-clamp-1" title="{{ $top_product }}">{{ $top_product }}</h3>
            </div>
            <div class="bg-blue-100 p-2 rounded-lg">
                <x-heroicon-o-fire class="w-6 h-6 text-blue-500" />
            </div>
        </div>
        <div class="mt-4">
             <button class="w-full py-2 px-4 bg-gray-50 text-gray-600 rounded-lg text-sm font-medium hover:bg-gray-100 transition-colors">
                View Analytics
            </button>
        </div>
    </div>
</div>
