<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name', 'Laravel') }}</title>
    <!-- Tailwind CDN for immediate styling support -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="{{ mix('css/app.css') }}" rel="stylesheet">
</head>
<body class="bg-gray-50 font-sans antialiased">
    <div id="app">
        <!-- Using Vue Header if possible, or a blade fallback -->
        <header class="bg-white shadow">
            <div class="container mx-auto px-4 py-6 flex justify-between items-center">
                 <a href="/" class="text-2xl font-bold text-amber-600">Store</a>
                 <nav>
                    <a href="/" class="text-gray-600 hover:text-amber-600 mx-3">Shop</a>
                    <a href="{{ route('blog.index') }}" class="text-gray-600 hover:text-amber-600 mx-3 font-semibold">Blog</a>
                    <a href="/admin" class="text-gray-600 hover:text-amber-600 mx-3">Admin</a>
                 </nav>
            </div>
        </header>

        <main>
            @yield('content')
        </main>
        
        <footer class="bg-gray-800 text-white mt-12 py-8">
            <div class="container mx-auto px-4 text-center">
                &copy; {{ date('Y') }} Store Name. All rights reserved.
            </div>
        </footer>
    </div>
    <script src="{{ mix('js/app.js') }}"></script>
</body>
</html>
