<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/api-test', function () {
    return 'API Test Works';
});



/* |-------------------------------------------------------------------------- | API Routes |-------------------------------------------------------------------------- | | Here is where you can register API routes for your application. These | routes are loaded by the RouteServiceProvider within a group which | is assigned the "api" middleware group. Enjoy building your API! | */

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/orders', [\App\Http\Controllers\Api\OrderController::class , 'index']);
    Route::get('/orders/{id}', [\App\Http\Controllers\Api\OrderController::class , 'show']);

    // Wishlist Routes
    Route::get('/wishlist', [\App\Http\Controllers\Api\WishlistController::class , 'index']);
    Route::post('/wishlist', [\App\Http\Controllers\Api\WishlistController::class , 'store']);
    Route::delete('/wishlist/{productId}', [\App\Http\Controllers\Api\WishlistController::class , 'destroy']);
    Route::get('/wishlist/check/{productId}', [\App\Http\Controllers\Api\WishlistController::class , 'check']);
});

// Auth routes
Route::post('/login', [\App\Http\Controllers\Api\AuthController::class , 'login']);
Route::post('/register', [\App\Http\Controllers\Api\AuthController::class , 'register']);
Route::middleware('auth:sanctum')->post('/logout', [\App\Http\Controllers\Api\AuthController::class , 'logout']);

Route::get('/categories', [\App\Http\Controllers\Api\CategoryController::class , 'index']);
Route::get('/categories/{slug}', [\App\Http\Controllers\Api\CategoryController::class , 'show']);

Route::get('/brands', [\App\Http\Controllers\Api\BrandController::class , 'index']);
Route::get('/flash-sale/active', [\App\Http\Controllers\Api\FlashSaleController::class , 'active']);

Route::post('/newsletter/subscribe', [\App\Http\Controllers\Api\NewsletterController::class , 'subscribe']);

Route::get('/products/suggestions', [\App\Http\Controllers\Api\ProductController::class , 'suggestions']);
Route::get('/products', [\App\Http\Controllers\Api\ProductController::class , 'index']);
Route::get('/products/{slug}', [\App\Http\Controllers\Api\ProductController::class , 'show']);

Route::get('/banners', [\App\Http\Controllers\Api\BannerController::class , 'index']);
Route::get('/home-data', [\App\Http\Controllers\HomeController::class , 'apiData']);
Route::post('/checkout', [\App\Http\Controllers\Api\CheckoutController::class , 'store']);

// Blog Routes
Route::get('/posts', [\App\Http\Controllers\Api\BlogController::class , 'index']);
Route::get('/posts/latest', [\App\Http\Controllers\Api\BlogController::class , 'latest']);
Route::get('/posts/{slug}', [\App\Http\Controllers\Api\BlogController::class , 'show']);

Route::get('/settings', [\App\Http\Controllers\Api\SiteSettingsController::class , 'index']);
Route::get('/testimonials', [\App\Http\Controllers\Api\TestimonialController::class , 'index']);
